/*
 * Decompiled with CFR 0.152.
 */
package io.jaconi.spring.rabbitmq.retry;

import io.jaconi.spring.rabbitmq.retry.RetryProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;

@Configuration
@ConditionalOnProperty(value={"jaconi.rabbitmq.listener.retry.enabled", "jaconi.rabbitmq.listener.retry.create-resources"}, havingValue="true")
public class RetryResourceConfiguration
implements BeanFactoryAware,
InitializingBean {
    private final RetryProperties properties;
    private ConfigurableBeanFactory beanFactory;

    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() {
        for (String sourceQueue : this.properties.queues().keySet()) {
            String dlxName = "%s-retry-never".formatted(sourceQueue);
            Exchange dlx = ExchangeBuilder.topicExchange((String)dlxName).build();
            this.beanFactory.registerSingleton(dlx.toString(), (Object)dlx);
            String retryExchangeName = "%s-retry".formatted(sourceQueue);
            Exchange retryExchange = ExchangeBuilder.headersExchange((String)retryExchangeName).alternate(dlxName).build();
            this.beanFactory.registerSingleton(retryExchange.toString(), (Object)retryExchange);
            String dlqName = "%s-retry-never".formatted(sourceQueue);
            Queue dlq = QueueBuilder.durable((String)dlqName).build();
            this.beanFactory.registerSingleton(dlq.toString(), (Object)dlq);
            Binding dlqBinding = BindingBuilder.bind((Queue)dlq).to(dlx).with("#").noargs();
            this.beanFactory.registerSingleton(dlqBinding.toString(), (Object)dlqBinding);
            String dispatchExchangeName = "%s-dispatch".formatted(sourceQueue);
            Exchange dispatchExchange = ExchangeBuilder.topicExchange((String)dispatchExchangeName).build();
            this.beanFactory.registerSingleton(dispatchExchange.toString(), (Object)dispatchExchange);
            Binding dispatchBinding = new Binding(sourceQueue, Binding.DestinationType.QUEUE, dispatchExchangeName, "#", Collections.emptyMap());
            this.beanFactory.registerSingleton(dispatchBinding.toString(), (Object)dispatchBinding);
            RetryProperties.RetryQueueProperties queueProperties = this.properties.queues().get(sourceQueue);
            List<Queue> queues = queueProperties.durations().stream().map(duration -> {
                String queueName = "%s-retry-in-%s".formatted(sourceQueue, duration);
                return QueueBuilder.durable((String)queueName).ttl((int)duration.toMillis()).deadLetterExchange(dispatchExchangeName).build();
            }).toList();
            queues.forEach(queue -> this.beanFactory.registerSingleton(queue.toString(), queue));
            int bindings = queueProperties.durations().size();
            if (queueProperties.maxAttempts() != null) {
                bindings = Math.max(queueProperties.maxAttempts(), queueProperties.durations().size());
            }
            for (int i = 0; i < bindings; ++i) {
                Queue queue2 = queues.get(Math.min(i, queues.size() - 1));
                Binding binding = BindingBuilder.bind((Queue)queue2).to(retryExchange).with("").and(Map.of("x-retry", i + 1, "x-match", "any-with-x"));
                this.beanFactory.registerSingleton(binding.toString(), (Object)binding);
            }
        }
    }

    public RetryResourceConfiguration(RetryProperties properties) {
        this.properties = properties;
    }
}

