/*
 * Decompiled with CFR 0.152.
 */
package io.jaconi.spring.rabbitmq.retry;

import io.jaconi.spring.rabbitmq.retry.RetryMessagesException;
import io.jaconi.spring.rabbitmq.retry.TechnicalHeadersFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.rabbit.listener.ConditionalRejectingErrorHandler;
import org.springframework.amqp.rabbit.listener.FatalExceptionStrategy;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component(value="retryErrorHandler")
public class RetryErrorHandler
extends ConditionalRejectingErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(RetryErrorHandler.class);
    private final AmqpTemplate amqpTemplate;

    public RetryErrorHandler(AmqpTemplate amqpTemplate) {
        super((FatalExceptionStrategy)new ConditionalRejectingErrorHandler.DefaultExceptionStrategy(){

            protected boolean isUserCauseFatal(@NonNull Throwable cause) {
                return true;
            }
        });
        this.amqpTemplate = amqpTemplate;
    }

    public void handleError(@NonNull Throwable t) {
        ListenerExecutionFailedException lefe;
        Throwable throwable;
        if (t instanceof ListenerExecutionFailedException && (throwable = (lefe = (ListenerExecutionFailedException)t).getCause()) instanceof RetryMessagesException) {
            RetryMessagesException rme = (RetryMessagesException)throwable;
            rme.getMessages().forEach(this::retryMessage);
            throw new ImmediateAcknowledgeAmqpException("acknowledge messages as they were scheduled for retry", t);
        }
        super.handleError(t);
    }

    private void retryMessage(Message<?> message) {
        long retry = this.getRetry(message);
        log.info("retrying message (attempt {}): {}", (Object)retry, message);
        String routingKey = (String)message.getHeaders().get((Object)"amqp_receivedRoutingKey", String.class);
        this.amqpTemplate.convertAndSend(this.getRetryExchange(message), routingKey, message.getPayload(), m -> {
            m.getMessageProperties().setHeader("x-retry", (Object)retry);
            TechnicalHeadersFilter.filterHeaders(message.getHeaders()).forEach(h -> m.getMessageProperties().setHeader(h, message.getHeaders().get(h)));
            return m;
        });
    }

    private long getRetry(Message<?> message) {
        Long previousRetryAttempt = (Long)message.getHeaders().get((Object)"x-retry", Long.class);
        if (previousRetryAttempt == null) {
            previousRetryAttempt = 0L;
        }
        return previousRetryAttempt + 1L;
    }

    private String getRetryExchange(Message<?> message) {
        return "%s-retry".formatted(message.getHeaders().get((Object)"amqp_consumerQueue", String.class));
    }
}

