/*
 * Decompiled with CFR 0.152.
 */
package io.jaconi.spring.rabbitmq.retry;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import io.jaconi.spring.rabbitmq.retry.RetryErrorHandler;
import io.jaconi.spring.rabbitmq.retry.RetryProperties;
import io.jaconi.spring.rabbitmq.retry.RetryResourceConfiguration;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.config.ContainerCustomizer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.util.ErrorHandler;

@AutoConfiguration(after={RabbitAutoConfiguration.class})
@ConditionalOnProperty(value={"jaconi.rabbitmq.listener.retry.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={RetryProperties.class})
@Import(value={RetryErrorHandler.class, RetryResourceConfiguration.class})
public class RetryAutoConfiguration {
    private static final String NOOP_LOGGER = "io.jaconi.spring.rabbitmq.retry.noop";
    private final RetryErrorHandler retryErrorHandler;

    @Bean
    public ContainerCustomizer<SimpleMessageListenerContainer> retryContainerCustomizer() {
        return container -> {
            container.setErrorHandler((ErrorHandler)this.retryErrorHandler);
            Logger logger = (Logger)LoggerFactory.getLogger((String)NOOP_LOGGER);
            logger.setLevel(Level.OFF);
            container.setErrorHandlerLoggerName(NOOP_LOGGER);
        };
    }

    public RetryAutoConfiguration(RetryErrorHandler retryErrorHandler) {
        this.retryErrorHandler = retryErrorHandler;
    }
}

