//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("MillisecondsKt")

package io.islandtime.measures

import io.islandtime.internal.MICROSECONDS_PER_MILLISECOND
import io.islandtime.internal.MILLISECONDS_PER_DAY
import io.islandtime.internal.MILLISECONDS_PER_HOUR
import io.islandtime.internal.MILLISECONDS_PER_MINUTE
import io.islandtime.internal.MILLISECONDS_PER_SECOND
import io.islandtime.internal.NANOSECONDS_PER_MILLISECOND
import io.islandtime.internal.minusExact
import io.islandtime.internal.negateExact
import io.islandtime.internal.plusExact
import io.islandtime.internal.timesExact
import io.islandtime.internal.toIntExact
import io.islandtime.internal.toZeroPaddedString
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Int
import kotlin.Long
import kotlin.PublishedApi
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue

/**
 * A number of milliseconds.
 */
@Suppress("NON_PUBLIC_PRIMARY_CONSTRUCTOR_OF_INLINE_CLASS")
inline class IntMilliseconds(
  /**
   * The underlying value.
   */
  val value: Int
) : Comparable<IntMilliseconds> {
  /**
   * Get the absolute value.
   * @throws ArithmeticException if overflow occurs
   */
  val absoluteValue: IntMilliseconds
    get() = if (value < 0) IntMilliseconds(value.negateExact()) else this
  /**
   * Convert to nanoseconds.
   */
  val inNanoseconds: LongNanoseconds
    get() = (value.toLong() * NANOSECONDS_PER_MILLISECOND).nanoseconds

  /**
   * Convert to microseconds.
   */
  val inMicroseconds: LongMicroseconds
    get() = (value.toLong() * MICROSECONDS_PER_MILLISECOND).microseconds

  /**
   * Convert to whole seconds.
   */
  val inSeconds: IntSeconds
    get() = (value / MILLISECONDS_PER_SECOND).seconds

  /**
   * Convert to whole minutes.
   */
  val inMinutes: IntMinutes
    get() = (value / MILLISECONDS_PER_MINUTE).minutes

  /**
   * Convert to whole hours.
   */
  val inHours: IntHours
    get() = (value / MILLISECONDS_PER_HOUR).hours

  /**
   * Convert to whole days.
   */
  val inDays: IntDays
    get() = (value / MILLISECONDS_PER_DAY).days

  /**
   * Is this duration zero?
   */
  fun isZero(): Boolean = value == 0

  /**
   * Is this duration negative?
   */
  fun isNegative(): Boolean = value < 0

  /**
   * Is this duration positive?
   */
  fun isPositive(): Boolean = value > 0

  override fun compareTo(other: IntMilliseconds): Int = value.compareTo(other.value)

  /**
   * Convert to an ISO-8601 time interval representation.
   */
  override fun toString(): String {
     return if (isZero()) {
       "PT0S"
     } else {
       buildString {
         val wholePart = (value / 1000).absoluteValue
         val fractionalPart = (value % 1000).absoluteValue
         if (isNegative()) { append('-') }
         append("PT")
         append(wholePart)
         if (fractionalPart != 0) {
           append('.')
           append(fractionalPart.toZeroPaddedString(3).dropLastWhile { it == '0' })
         }
         append('S')
       }
     }
  }

  /**
   * Negate the value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun unaryMinus() = IntMilliseconds(value.negateExact())

  /**
   * Negate the value without checking for overflow.
   */
  internal fun negateUnchecked() = IntMilliseconds(-value)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Int) = this.toLongMilliseconds() * scalar

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Long) = this.toLongMilliseconds() * scalar

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Int): IntMilliseconds {
     return if (scalar == -1) {
       -this
     } else {
       IntMilliseconds(value / scalar)
     }
  }

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if the scalar is zero
   */
  operator fun div(scalar: Long): LongMilliseconds = this.toLongMilliseconds() / scalar
  operator fun rem(scalar: Int) = IntMilliseconds(value % scalar)

  operator fun rem(scalar: Long) = this.toLongMilliseconds() % scalar

  operator fun plus(nanoseconds: IntNanoseconds) = this.toLongMilliseconds().inNanoseconds +
      nanoseconds.toLongNanoseconds()

  operator fun minus(nanoseconds: IntNanoseconds) = this.toLongMilliseconds().inNanoseconds -
      nanoseconds.toLongNanoseconds()

  operator fun plus(nanoseconds: LongNanoseconds) = this.toLongMilliseconds().inNanoseconds +
      nanoseconds

  operator fun minus(nanoseconds: LongNanoseconds) = this.toLongMilliseconds().inNanoseconds -
      nanoseconds

  operator fun plus(microseconds: IntMicroseconds) = this.toLongMilliseconds().inMicroseconds +
      microseconds.toLongMicroseconds()

  operator fun minus(microseconds: IntMicroseconds) = this.toLongMilliseconds().inMicroseconds -
      microseconds.toLongMicroseconds()

  operator fun plus(microseconds: LongMicroseconds) = this.toLongMilliseconds().inMicroseconds +
      microseconds

  operator fun minus(microseconds: LongMicroseconds) = this.toLongMilliseconds().inMicroseconds -
      microseconds

  operator fun plus(milliseconds: IntMilliseconds) = LongMilliseconds(value.toLong() plusExact
      milliseconds.value)

  operator fun minus(milliseconds: IntMilliseconds) = LongMilliseconds(value.toLong() minusExact
      milliseconds.value)

  operator fun plus(milliseconds: LongMilliseconds) = LongMilliseconds(value.toLong() plusExact
      milliseconds.value)

  operator fun minus(milliseconds: LongMilliseconds) = LongMilliseconds(value.toLong() minusExact
      milliseconds.value)

  operator fun plus(seconds: IntSeconds) = this.toLongMilliseconds() + seconds.inMilliseconds

  operator fun minus(seconds: IntSeconds) = this.toLongMilliseconds() - seconds.inMilliseconds

  operator fun plus(seconds: LongSeconds) = this.toLongMilliseconds() + seconds.inMilliseconds

  operator fun minus(seconds: LongSeconds) = this.toLongMilliseconds() - seconds.inMilliseconds

  operator fun plus(minutes: IntMinutes) = this.toLongMilliseconds() + minutes.inMilliseconds

  operator fun minus(minutes: IntMinutes) = this.toLongMilliseconds() - minutes.inMilliseconds

  operator fun plus(minutes: LongMinutes) = this.toLongMilliseconds() + minutes.inMilliseconds

  operator fun minus(minutes: LongMinutes) = this.toLongMilliseconds() - minutes.inMilliseconds

  operator fun plus(hours: IntHours) = this.toLongMilliseconds() + hours.inMilliseconds

  operator fun minus(hours: IntHours) = this.toLongMilliseconds() - hours.inMilliseconds

  operator fun plus(hours: LongHours) = this.toLongMilliseconds() + hours.inMilliseconds

  operator fun minus(hours: LongHours) = this.toLongMilliseconds() - hours.inMilliseconds

  operator fun plus(days: IntDays) = this.toLongMilliseconds() + days.inMilliseconds

  operator fun minus(days: IntDays) = this.toLongMilliseconds() - days.inMilliseconds

  operator fun plus(days: LongDays) = this.toLongMilliseconds() + days.inMilliseconds

  operator fun minus(days: LongDays) = this.toLongMilliseconds() - days.inMilliseconds

  inline fun <T> toComponents(action: (seconds: IntSeconds, milliseconds: IntMilliseconds) -> T):
      T {
    val seconds = this.inSeconds
    val milliseconds = (this - seconds).toIntMillisecondsUnchecked()
    return action(seconds, milliseconds)
  }

  inline fun <T> toComponents(action: (
    minutes: IntMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds
  ) -> T): T {
    val minutes = this.inMinutes
    val seconds = (this - minutes).toIntMillisecondsUnchecked().inSeconds
    val milliseconds = (this - minutes - seconds).toIntMillisecondsUnchecked()
    return action(minutes, seconds, milliseconds)
  }

  inline fun <T> toComponents(action: (
    hours: IntHours,
    minutes: IntMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds
  ) -> T): T {
    val hours = this.inHours
    val minutes = (this - hours).toIntMillisecondsUnchecked().inMinutes
    val seconds = (this - hours - minutes).toIntMillisecondsUnchecked().inSeconds
    val milliseconds = (this - hours - minutes - seconds).toIntMillisecondsUnchecked()
    return action(hours, minutes, seconds, milliseconds)
  }

  inline fun <T> toComponents(action: (
    days: IntDays,
    hours: IntHours,
    minutes: IntMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds
  ) -> T): T {
    val days = this.inDays
    val hours = (this - days).toIntMillisecondsUnchecked().inHours
    val minutes = (this - days - hours).toIntMillisecondsUnchecked().inMinutes
    val seconds = (this - days - hours - minutes).toIntMillisecondsUnchecked().inSeconds
    val milliseconds = (this - days - hours - minutes - seconds).toIntMillisecondsUnchecked()
    return action(days, hours, minutes, seconds, milliseconds)
  }

  /**
   * Convert to [LongMilliseconds].
   */
  fun toLongMilliseconds() = LongMilliseconds(value.toLong())

  /**
   * Convert to a unit-less `Long` value.
   */
  fun toLong() = value.toLong()

  companion object {
    /**
     * The smallest supported value.
     */
    val MIN: IntMilliseconds = IntMilliseconds(Int.MIN_VALUE)

    /**
     * The largest supported value.
     */
    val MAX: IntMilliseconds = IntMilliseconds(Int.MAX_VALUE)
  }
}

/**
 * Convert to [IntMilliseconds].
 */
val Int.milliseconds: IntMilliseconds
  get() = IntMilliseconds(this)

/**
 * Multiply by a number of milliseconds.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Int.times(milliseconds: IntMilliseconds) = milliseconds * this

/**
 * Multiply by a number of milliseconds.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Long.times(milliseconds: IntMilliseconds) = milliseconds * this

/**
 * A number of milliseconds.
 */
@Suppress("NON_PUBLIC_PRIMARY_CONSTRUCTOR_OF_INLINE_CLASS")
inline class LongMilliseconds(
  /**
   * The underlying value.
   */
  val value: Long
) : Comparable<LongMilliseconds> {
  /**
   * Get the absolute value.
   * @throws ArithmeticException if overflow occurs
   */
  val absoluteValue: LongMilliseconds
    get() = if (value < 0) LongMilliseconds(value.negateExact()) else this
  /**
   * Convert to nanoseconds.
   * @throws ArithmeticException if overflow occurs
   */
  val inNanoseconds: LongNanoseconds
    get() = (value timesExact NANOSECONDS_PER_MILLISECOND).nanoseconds

  /**
   * Convert to nanoseconds without checking for overflow.
   */
  internal val inNanosecondsUnchecked: LongNanoseconds
    get() = (value * NANOSECONDS_PER_MILLISECOND).nanoseconds

  /**
   * Convert to microseconds.
   * @throws ArithmeticException if overflow occurs
   */
  val inMicroseconds: LongMicroseconds
    get() = (value timesExact MICROSECONDS_PER_MILLISECOND).microseconds

  /**
   * Convert to microseconds without checking for overflow.
   */
  internal val inMicrosecondsUnchecked: LongMicroseconds
    get() = (value * MICROSECONDS_PER_MILLISECOND).microseconds

  /**
   * Convert to whole seconds.
   */
  val inSeconds: LongSeconds
    get() = (value / MILLISECONDS_PER_SECOND).seconds

  /**
   * Convert to whole minutes.
   */
  val inMinutes: LongMinutes
    get() = (value / MILLISECONDS_PER_MINUTE).minutes

  /**
   * Convert to whole hours.
   */
  val inHours: LongHours
    get() = (value / MILLISECONDS_PER_HOUR).hours

  /**
   * Convert to whole days.
   */
  val inDays: LongDays
    get() = (value / MILLISECONDS_PER_DAY).days

  /**
   * Is this duration zero?
   */
  fun isZero(): Boolean = value == 0L

  /**
   * Is this duration negative?
   */
  fun isNegative(): Boolean = value < 0L

  /**
   * Is this duration positive?
   */
  fun isPositive(): Boolean = value > 0L

  override fun compareTo(other: LongMilliseconds): Int = value.compareTo(other.value)

  /**
   * Convert to an ISO-8601 time interval representation.
   */
  override fun toString(): String {
     return if (isZero()) {
       "PT0S"
     } else {
       buildString {
         val wholePart = (value / 1000).absoluteValue
         val fractionalPart = ((value % 1000).toInt()).absoluteValue
         if (isNegative()) { append('-') }
         append("PT")
         append(wholePart)
         if (fractionalPart != 0) {
           append('.')
           append(fractionalPart.toZeroPaddedString(3).dropLastWhile { it == '0' })
         }
         append('S')
       }
     }
  }

  /**
   * Negate the value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun unaryMinus() = LongMilliseconds(value.negateExact())

  /**
   * Negate the value without checking for overflow.
   */
  internal fun negateUnchecked() = LongMilliseconds(-value)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Int) = LongMilliseconds(value timesExact scalar)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Long) = LongMilliseconds(value timesExact scalar)

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Int): LongMilliseconds {
     return if (scalar == -1) {
       -this
     } else {
       LongMilliseconds(value / scalar)
     }
  }

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Long): LongMilliseconds {
     return if (scalar == -1L) {
       -this
     } else {
       LongMilliseconds(value / scalar)
     }
  }

  operator fun rem(scalar: Int) = LongMilliseconds(value % scalar)

  operator fun rem(scalar: Long) = LongMilliseconds(value % scalar)

  operator fun plus(nanoseconds: IntNanoseconds) = this.inNanoseconds + nanoseconds

  operator fun minus(nanoseconds: IntNanoseconds) = this.inNanoseconds - nanoseconds

  operator fun plus(nanoseconds: LongNanoseconds) = this.inNanoseconds + nanoseconds

  operator fun minus(nanoseconds: LongNanoseconds) = this.inNanoseconds - nanoseconds

  operator fun plus(microseconds: IntMicroseconds) = this.inMicroseconds + microseconds

  operator fun minus(microseconds: IntMicroseconds) = this.inMicroseconds - microseconds

  operator fun plus(microseconds: LongMicroseconds) = this.inMicroseconds + microseconds

  operator fun minus(microseconds: LongMicroseconds) = this.inMicroseconds - microseconds

  operator fun plus(milliseconds: IntMilliseconds) = LongMilliseconds(value plusExact
      milliseconds.value)

  operator fun minus(milliseconds: IntMilliseconds) = LongMilliseconds(value minusExact
      milliseconds.value)

  operator fun plus(milliseconds: LongMilliseconds) = LongMilliseconds(value plusExact
      milliseconds.value)

  operator fun minus(milliseconds: LongMilliseconds) = LongMilliseconds(value minusExact
      milliseconds.value)

  operator fun plus(seconds: IntSeconds) = this + seconds.inMilliseconds

  operator fun minus(seconds: IntSeconds) = this - seconds.inMilliseconds

  operator fun plus(seconds: LongSeconds) = this + seconds.inMilliseconds

  operator fun minus(seconds: LongSeconds) = this - seconds.inMilliseconds

  operator fun plus(minutes: IntMinutes) = this + minutes.inMilliseconds

  operator fun minus(minutes: IntMinutes) = this - minutes.inMilliseconds

  operator fun plus(minutes: LongMinutes) = this + minutes.inMilliseconds

  operator fun minus(minutes: LongMinutes) = this - minutes.inMilliseconds

  operator fun plus(hours: IntHours) = this + hours.inMilliseconds

  operator fun minus(hours: IntHours) = this - hours.inMilliseconds

  operator fun plus(hours: LongHours) = this + hours.inMilliseconds

  operator fun minus(hours: LongHours) = this - hours.inMilliseconds

  operator fun plus(days: IntDays) = this + days.inMilliseconds

  operator fun minus(days: IntDays) = this - days.inMilliseconds

  operator fun plus(days: LongDays) = this + days.inMilliseconds

  operator fun minus(days: LongDays) = this - days.inMilliseconds

  inline fun <T> toComponents(action: (seconds: LongSeconds, milliseconds: IntMilliseconds) -> T):
      T {
    val seconds = this.inSeconds
    val milliseconds = (this - seconds).toIntMillisecondsUnchecked()
    return action(seconds, milliseconds)
  }

  inline fun <T> toComponents(action: (
    minutes: LongMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds
  ) -> T): T {
    val minutes = this.inMinutes
    val seconds = (this - minutes).toIntMillisecondsUnchecked().inSeconds
    val milliseconds = (this - minutes - seconds).toIntMillisecondsUnchecked()
    return action(minutes, seconds, milliseconds)
  }

  inline fun <T> toComponents(action: (
    hours: LongHours,
    minutes: IntMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds
  ) -> T): T {
    val hours = this.inHours
    val minutes = (this - hours).toIntMillisecondsUnchecked().inMinutes
    val seconds = (this - hours - minutes).toIntMillisecondsUnchecked().inSeconds
    val milliseconds = (this - hours - minutes - seconds).toIntMillisecondsUnchecked()
    return action(hours, minutes, seconds, milliseconds)
  }

  inline fun <T> toComponents(action: (
    days: LongDays,
    hours: IntHours,
    minutes: IntMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds
  ) -> T): T {
    val days = this.inDays
    val hours = (this - days).toIntMillisecondsUnchecked().inHours
    val minutes = (this - days - hours).toIntMillisecondsUnchecked().inMinutes
    val seconds = (this - days - hours - minutes).toIntMillisecondsUnchecked().inSeconds
    val milliseconds = (this - days - hours - minutes - seconds).toIntMillisecondsUnchecked()
    return action(days, hours, minutes, seconds, milliseconds)
  }

  /**
   * Convert to [IntMilliseconds].
   * @throws ArithmeticException if overflow occurs
   */
  fun toIntMilliseconds() = IntMilliseconds(value.toIntExact())

  /**
   * Convert to [IntMilliseconds] without checking for overflow.
   */
  @PublishedApi
  internal fun toIntMillisecondsUnchecked() = IntMilliseconds(value.toInt())

  /**
   * Convert to a unit-less `Int` value.
   * @throws ArithmeticException if overflow occurs
   */
  fun toInt() = value.toIntExact()

  /**
   * Convert to a unit-less `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked() = value.toInt()

  companion object {
    /**
     * The smallest supported value.
     */
    val MIN: LongMilliseconds = LongMilliseconds(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    val MAX: LongMilliseconds = LongMilliseconds(Long.MAX_VALUE)
  }
}

/**
 * Convert to [LongMilliseconds].
 */
val Long.milliseconds: LongMilliseconds
  get() = LongMilliseconds(this)

/**
 * Multiply by a number of milliseconds.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Int.times(milliseconds: LongMilliseconds) = milliseconds * this

/**
 * Multiply by a number of milliseconds.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Long.times(milliseconds: LongMilliseconds) = milliseconds * this
