//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("MicrosecondsKt")

package io.islandtime.measures

import io.islandtime.internal.MICROSECONDS_PER_DAY
import io.islandtime.internal.MICROSECONDS_PER_HOUR
import io.islandtime.internal.MICROSECONDS_PER_MILLISECOND
import io.islandtime.internal.MICROSECONDS_PER_MINUTE
import io.islandtime.internal.MICROSECONDS_PER_SECOND
import io.islandtime.internal.NANOSECONDS_PER_MICROSECOND
import io.islandtime.internal.minusExact
import io.islandtime.internal.negateExact
import io.islandtime.internal.plusExact
import io.islandtime.internal.timesExact
import io.islandtime.internal.toIntExact
import io.islandtime.internal.toZeroPaddedString
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Int
import kotlin.Long
import kotlin.PublishedApi
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue

/**
 * A number of microseconds.
 */
@Suppress("NON_PUBLIC_PRIMARY_CONSTRUCTOR_OF_INLINE_CLASS")
inline class IntMicroseconds(
  /**
   * The underlying value.
   */
  val value: Int
) : Comparable<IntMicroseconds> {
  /**
   * Get the absolute value.
   * @throws ArithmeticException if overflow occurs
   */
  val absoluteValue: IntMicroseconds
    get() = if (value < 0) IntMicroseconds(value.negateExact()) else this
  /**
   * Convert to nanoseconds.
   */
  val inNanoseconds: LongNanoseconds
    get() = (value.toLong() * NANOSECONDS_PER_MICROSECOND).nanoseconds

  /**
   * Convert to whole milliseconds.
   */
  val inMilliseconds: IntMilliseconds
    get() = (value / MICROSECONDS_PER_MILLISECOND).milliseconds

  /**
   * Convert to whole seconds.
   */
  val inSeconds: IntSeconds
    get() = (value / MICROSECONDS_PER_SECOND).seconds

  /**
   * Convert to whole minutes.
   */
  val inMinutes: IntMinutes
    get() = (value / MICROSECONDS_PER_MINUTE).minutes

  /**
   * Convert to whole hours.
   */
  val inHours: IntHours
    get() = (value / MICROSECONDS_PER_HOUR).toInt().hours

  /**
   * Convert to whole days.
   */
  val inDays: IntDays
    get() = (value / MICROSECONDS_PER_DAY).toInt().days

  /**
   * Is this duration zero?
   */
  fun isZero(): Boolean = value == 0

  /**
   * Is this duration negative?
   */
  fun isNegative(): Boolean = value < 0

  /**
   * Is this duration positive?
   */
  fun isPositive(): Boolean = value > 0

  override fun compareTo(other: IntMicroseconds): Int = value.compareTo(other.value)

  /**
   * Convert to an ISO-8601 time interval representation.
   */
  override fun toString(): String {
     return if (isZero()) {
       "PT0S"
     } else {
       buildString {
         val wholePart = (value / 1000000).absoluteValue
         val fractionalPart = (value % 1000000).absoluteValue
         if (isNegative()) { append('-') }
         append("PT")
         append(wholePart)
         if (fractionalPart != 0) {
           append('.')
           append(fractionalPart.toZeroPaddedString(6).dropLastWhile { it == '0' })
         }
         append('S')
       }
     }
  }

  /**
   * Negate the value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun unaryMinus() = IntMicroseconds(value.negateExact())

  /**
   * Negate the value without checking for overflow.
   */
  internal fun negateUnchecked() = IntMicroseconds(-value)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Int) = this.toLongMicroseconds() * scalar

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Long) = this.toLongMicroseconds() * scalar

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Int): IntMicroseconds {
     return if (scalar == -1) {
       -this
     } else {
       IntMicroseconds(value / scalar)
     }
  }

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if the scalar is zero
   */
  operator fun div(scalar: Long): LongMicroseconds = this.toLongMicroseconds() / scalar
  operator fun rem(scalar: Int) = IntMicroseconds(value % scalar)

  operator fun rem(scalar: Long) = this.toLongMicroseconds() % scalar

  operator fun plus(nanoseconds: IntNanoseconds) = this.toLongMicroseconds().inNanoseconds +
      nanoseconds.toLongNanoseconds()

  operator fun minus(nanoseconds: IntNanoseconds) = this.toLongMicroseconds().inNanoseconds -
      nanoseconds.toLongNanoseconds()

  operator fun plus(nanoseconds: LongNanoseconds) = this.toLongMicroseconds().inNanoseconds +
      nanoseconds

  operator fun minus(nanoseconds: LongNanoseconds) = this.toLongMicroseconds().inNanoseconds -
      nanoseconds

  operator fun plus(microseconds: IntMicroseconds) = LongMicroseconds(value.toLong() plusExact
      microseconds.value)

  operator fun minus(microseconds: IntMicroseconds) = LongMicroseconds(value.toLong() minusExact
      microseconds.value)

  operator fun plus(microseconds: LongMicroseconds) = LongMicroseconds(value.toLong() plusExact
      microseconds.value)

  operator fun minus(microseconds: LongMicroseconds) = LongMicroseconds(value.toLong() minusExact
      microseconds.value)

  operator fun plus(milliseconds: IntMilliseconds) = this.toLongMicroseconds() +
      milliseconds.inMicroseconds

  operator fun minus(milliseconds: IntMilliseconds) = this.toLongMicroseconds() -
      milliseconds.inMicroseconds

  operator fun plus(milliseconds: LongMilliseconds) = this.toLongMicroseconds() +
      milliseconds.inMicroseconds

  operator fun minus(milliseconds: LongMilliseconds) = this.toLongMicroseconds() -
      milliseconds.inMicroseconds

  operator fun plus(seconds: IntSeconds) = this.toLongMicroseconds() + seconds.inMicroseconds

  operator fun minus(seconds: IntSeconds) = this.toLongMicroseconds() - seconds.inMicroseconds

  operator fun plus(seconds: LongSeconds) = this.toLongMicroseconds() + seconds.inMicroseconds

  operator fun minus(seconds: LongSeconds) = this.toLongMicroseconds() - seconds.inMicroseconds

  operator fun plus(minutes: IntMinutes) = this.toLongMicroseconds() + minutes.inMicroseconds

  operator fun minus(minutes: IntMinutes) = this.toLongMicroseconds() - minutes.inMicroseconds

  operator fun plus(minutes: LongMinutes) = this.toLongMicroseconds() + minutes.inMicroseconds

  operator fun minus(minutes: LongMinutes) = this.toLongMicroseconds() - minutes.inMicroseconds

  operator fun plus(hours: IntHours) = this.toLongMicroseconds() + hours.inMicroseconds

  operator fun minus(hours: IntHours) = this.toLongMicroseconds() - hours.inMicroseconds

  operator fun plus(hours: LongHours) = this.toLongMicroseconds() + hours.inMicroseconds

  operator fun minus(hours: LongHours) = this.toLongMicroseconds() - hours.inMicroseconds

  operator fun plus(days: IntDays) = this.toLongMicroseconds() + days.inMicroseconds

  operator fun minus(days: IntDays) = this.toLongMicroseconds() - days.inMicroseconds

  operator fun plus(days: LongDays) = this.toLongMicroseconds() + days.inMicroseconds

  operator fun minus(days: LongDays) = this.toLongMicroseconds() - days.inMicroseconds

  inline fun <T> toComponents(action: (milliseconds: IntMilliseconds,
      microseconds: IntMicroseconds) -> T): T {
    val milliseconds = this.inMilliseconds
    val microseconds = (this - milliseconds).toIntMicrosecondsUnchecked()
    return action(milliseconds, microseconds)
  }

  inline fun <T> toComponents(action: (
    seconds: IntSeconds,
    milliseconds: IntMilliseconds,
    microseconds: IntMicroseconds
  ) -> T): T {
    val seconds = this.inSeconds
    val milliseconds = (this - seconds).toIntMicrosecondsUnchecked().inMilliseconds
    val microseconds = (this - seconds - milliseconds).toIntMicrosecondsUnchecked()
    return action(seconds, milliseconds, microseconds)
  }

  inline fun <T> toComponents(action: (
    minutes: IntMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds,
    microseconds: IntMicroseconds
  ) -> T): T {
    val minutes = this.inMinutes
    val seconds = (this - minutes).toIntMicrosecondsUnchecked().inSeconds
    val milliseconds = (this - minutes - seconds).toIntMicrosecondsUnchecked().inMilliseconds
    val microseconds = (this - minutes - seconds - milliseconds).toIntMicrosecondsUnchecked()
    return action(minutes, seconds, milliseconds, microseconds)
  }

  inline fun <T> toComponents(action: (
    hours: IntHours,
    minutes: IntMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds,
    microseconds: IntMicroseconds
  ) -> T): T {
    val hours = this.inHours
    val minutes = (this - hours).toIntMicrosecondsUnchecked().inMinutes
    val seconds = (this - hours - minutes).toIntMicrosecondsUnchecked().inSeconds
    val milliseconds = (this - hours - minutes -
        seconds).toIntMicrosecondsUnchecked().inMilliseconds
    val microseconds = (this - hours - minutes - seconds -
        milliseconds).toIntMicrosecondsUnchecked()
    return action(hours, minutes, seconds, milliseconds, microseconds)
  }

  inline fun <T> toComponents(action: (
    days: IntDays,
    hours: IntHours,
    minutes: IntMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds,
    microseconds: IntMicroseconds
  ) -> T): T {
    val days = this.inDays
    val hours = (this - days).toIntMicrosecondsUnchecked().inHours
    val minutes = (this - days - hours).toIntMicrosecondsUnchecked().inMinutes
    val seconds = (this - days - hours - minutes).toIntMicrosecondsUnchecked().inSeconds
    val milliseconds = (this - days - hours - minutes -
        seconds).toIntMicrosecondsUnchecked().inMilliseconds
    val microseconds = (this - days - hours - minutes - seconds -
        milliseconds).toIntMicrosecondsUnchecked()
    return action(days, hours, minutes, seconds, milliseconds, microseconds)
  }

  /**
   * Convert to [LongMicroseconds].
   */
  fun toLongMicroseconds() = LongMicroseconds(value.toLong())

  /**
   * Convert to a unit-less `Long` value.
   */
  fun toLong() = value.toLong()

  companion object {
    /**
     * The smallest supported value.
     */
    val MIN: IntMicroseconds = IntMicroseconds(Int.MIN_VALUE)

    /**
     * The largest supported value.
     */
    val MAX: IntMicroseconds = IntMicroseconds(Int.MAX_VALUE)
  }
}

/**
 * Convert to [IntMicroseconds].
 */
val Int.microseconds: IntMicroseconds
  get() = IntMicroseconds(this)

/**
 * Multiply by a number of microseconds.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Int.times(microseconds: IntMicroseconds) = microseconds * this

/**
 * Multiply by a number of microseconds.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Long.times(microseconds: IntMicroseconds) = microseconds * this

/**
 * A number of microseconds.
 */
@Suppress("NON_PUBLIC_PRIMARY_CONSTRUCTOR_OF_INLINE_CLASS")
inline class LongMicroseconds(
  /**
   * The underlying value.
   */
  val value: Long
) : Comparable<LongMicroseconds> {
  /**
   * Get the absolute value.
   * @throws ArithmeticException if overflow occurs
   */
  val absoluteValue: LongMicroseconds
    get() = if (value < 0) LongMicroseconds(value.negateExact()) else this
  /**
   * Convert to nanoseconds.
   * @throws ArithmeticException if overflow occurs
   */
  val inNanoseconds: LongNanoseconds
    get() = (value timesExact NANOSECONDS_PER_MICROSECOND).nanoseconds

  /**
   * Convert to nanoseconds without checking for overflow.
   */
  internal val inNanosecondsUnchecked: LongNanoseconds
    get() = (value * NANOSECONDS_PER_MICROSECOND).nanoseconds

  /**
   * Convert to whole milliseconds.
   */
  val inMilliseconds: LongMilliseconds
    get() = (value / MICROSECONDS_PER_MILLISECOND).milliseconds

  /**
   * Convert to whole seconds.
   */
  val inSeconds: LongSeconds
    get() = (value / MICROSECONDS_PER_SECOND).seconds

  /**
   * Convert to whole minutes.
   */
  val inMinutes: LongMinutes
    get() = (value / MICROSECONDS_PER_MINUTE).minutes

  /**
   * Convert to whole hours.
   */
  val inHours: LongHours
    get() = (value / MICROSECONDS_PER_HOUR).hours

  /**
   * Convert to whole days.
   */
  val inDays: LongDays
    get() = (value / MICROSECONDS_PER_DAY).days

  /**
   * Is this duration zero?
   */
  fun isZero(): Boolean = value == 0L

  /**
   * Is this duration negative?
   */
  fun isNegative(): Boolean = value < 0L

  /**
   * Is this duration positive?
   */
  fun isPositive(): Boolean = value > 0L

  override fun compareTo(other: LongMicroseconds): Int = value.compareTo(other.value)

  /**
   * Convert to an ISO-8601 time interval representation.
   */
  override fun toString(): String {
     return if (isZero()) {
       "PT0S"
     } else {
       buildString {
         val wholePart = (value / 1000000).absoluteValue
         val fractionalPart = ((value % 1000000).toInt()).absoluteValue
         if (isNegative()) { append('-') }
         append("PT")
         append(wholePart)
         if (fractionalPart != 0) {
           append('.')
           append(fractionalPart.toZeroPaddedString(6).dropLastWhile { it == '0' })
         }
         append('S')
       }
     }
  }

  /**
   * Negate the value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun unaryMinus() = LongMicroseconds(value.negateExact())

  /**
   * Negate the value without checking for overflow.
   */
  internal fun negateUnchecked() = LongMicroseconds(-value)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Int) = LongMicroseconds(value timesExact scalar)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Long) = LongMicroseconds(value timesExact scalar)

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Int): LongMicroseconds {
     return if (scalar == -1) {
       -this
     } else {
       LongMicroseconds(value / scalar)
     }
  }

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Long): LongMicroseconds {
     return if (scalar == -1L) {
       -this
     } else {
       LongMicroseconds(value / scalar)
     }
  }

  operator fun rem(scalar: Int) = LongMicroseconds(value % scalar)

  operator fun rem(scalar: Long) = LongMicroseconds(value % scalar)

  operator fun plus(nanoseconds: IntNanoseconds) = this.inNanoseconds + nanoseconds

  operator fun minus(nanoseconds: IntNanoseconds) = this.inNanoseconds - nanoseconds

  operator fun plus(nanoseconds: LongNanoseconds) = this.inNanoseconds + nanoseconds

  operator fun minus(nanoseconds: LongNanoseconds) = this.inNanoseconds - nanoseconds

  operator fun plus(microseconds: IntMicroseconds) = LongMicroseconds(value plusExact
      microseconds.value)

  operator fun minus(microseconds: IntMicroseconds) = LongMicroseconds(value minusExact
      microseconds.value)

  operator fun plus(microseconds: LongMicroseconds) = LongMicroseconds(value plusExact
      microseconds.value)

  operator fun minus(microseconds: LongMicroseconds) = LongMicroseconds(value minusExact
      microseconds.value)

  operator fun plus(milliseconds: IntMilliseconds) = this + milliseconds.inMicroseconds

  operator fun minus(milliseconds: IntMilliseconds) = this - milliseconds.inMicroseconds

  operator fun plus(milliseconds: LongMilliseconds) = this + milliseconds.inMicroseconds

  operator fun minus(milliseconds: LongMilliseconds) = this - milliseconds.inMicroseconds

  operator fun plus(seconds: IntSeconds) = this + seconds.inMicroseconds

  operator fun minus(seconds: IntSeconds) = this - seconds.inMicroseconds

  operator fun plus(seconds: LongSeconds) = this + seconds.inMicroseconds

  operator fun minus(seconds: LongSeconds) = this - seconds.inMicroseconds

  operator fun plus(minutes: IntMinutes) = this + minutes.inMicroseconds

  operator fun minus(minutes: IntMinutes) = this - minutes.inMicroseconds

  operator fun plus(minutes: LongMinutes) = this + minutes.inMicroseconds

  operator fun minus(minutes: LongMinutes) = this - minutes.inMicroseconds

  operator fun plus(hours: IntHours) = this + hours.inMicroseconds

  operator fun minus(hours: IntHours) = this - hours.inMicroseconds

  operator fun plus(hours: LongHours) = this + hours.inMicroseconds

  operator fun minus(hours: LongHours) = this - hours.inMicroseconds

  operator fun plus(days: IntDays) = this + days.inMicroseconds

  operator fun minus(days: IntDays) = this - days.inMicroseconds

  operator fun plus(days: LongDays) = this + days.inMicroseconds

  operator fun minus(days: LongDays) = this - days.inMicroseconds

  inline fun <T> toComponents(action: (milliseconds: LongMilliseconds,
      microseconds: IntMicroseconds) -> T): T {
    val milliseconds = this.inMilliseconds
    val microseconds = (this - milliseconds).toIntMicrosecondsUnchecked()
    return action(milliseconds, microseconds)
  }

  inline fun <T> toComponents(action: (
    seconds: LongSeconds,
    milliseconds: IntMilliseconds,
    microseconds: IntMicroseconds
  ) -> T): T {
    val seconds = this.inSeconds
    val milliseconds = (this - seconds).toIntMicrosecondsUnchecked().inMilliseconds
    val microseconds = (this - seconds - milliseconds).toIntMicrosecondsUnchecked()
    return action(seconds, milliseconds, microseconds)
  }

  inline fun <T> toComponents(action: (
    minutes: LongMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds,
    microseconds: IntMicroseconds
  ) -> T): T {
    val minutes = this.inMinutes
    val seconds = (this - minutes).toIntMicrosecondsUnchecked().inSeconds
    val milliseconds = (this - minutes - seconds).toIntMicrosecondsUnchecked().inMilliseconds
    val microseconds = (this - minutes - seconds - milliseconds).toIntMicrosecondsUnchecked()
    return action(minutes, seconds, milliseconds, microseconds)
  }

  inline fun <T> toComponents(action: (
    hours: LongHours,
    minutes: IntMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds,
    microseconds: IntMicroseconds
  ) -> T): T {
    val hours = this.inHours
    val minutes = (this - hours).toIntMicrosecondsUnchecked().inMinutes
    val seconds = (this - hours - minutes).toIntMicrosecondsUnchecked().inSeconds
    val milliseconds = (this - hours - minutes -
        seconds).toIntMicrosecondsUnchecked().inMilliseconds
    val microseconds = (this - hours - minutes - seconds -
        milliseconds).toIntMicrosecondsUnchecked()
    return action(hours, minutes, seconds, milliseconds, microseconds)
  }

  inline fun <T> toComponents(action: (
    days: LongDays,
    hours: IntHours,
    minutes: IntMinutes,
    seconds: IntSeconds,
    milliseconds: IntMilliseconds,
    microseconds: IntMicroseconds
  ) -> T): T {
    val days = this.inDays
    val hours = (this - days).toIntMicrosecondsUnchecked().inHours
    val minutes = (this - days - hours).toIntMicrosecondsUnchecked().inMinutes
    val seconds = (this - days - hours - minutes).toIntMicrosecondsUnchecked().inSeconds
    val milliseconds = (this - days - hours - minutes -
        seconds).toIntMicrosecondsUnchecked().inMilliseconds
    val microseconds = (this - days - hours - minutes - seconds -
        milliseconds).toIntMicrosecondsUnchecked()
    return action(days, hours, minutes, seconds, milliseconds, microseconds)
  }

  /**
   * Convert to [IntMicroseconds].
   * @throws ArithmeticException if overflow occurs
   */
  fun toIntMicroseconds() = IntMicroseconds(value.toIntExact())

  /**
   * Convert to [IntMicroseconds] without checking for overflow.
   */
  @PublishedApi
  internal fun toIntMicrosecondsUnchecked() = IntMicroseconds(value.toInt())

  /**
   * Convert to a unit-less `Int` value.
   * @throws ArithmeticException if overflow occurs
   */
  fun toInt() = value.toIntExact()

  /**
   * Convert to a unit-less `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked() = value.toInt()

  companion object {
    /**
     * The smallest supported value.
     */
    val MIN: LongMicroseconds = LongMicroseconds(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    val MAX: LongMicroseconds = LongMicroseconds(Long.MAX_VALUE)
  }
}

/**
 * Convert to [LongMicroseconds].
 */
val Long.microseconds: LongMicroseconds
  get() = LongMicroseconds(this)

/**
 * Multiply by a number of microseconds.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Int.times(microseconds: LongMicroseconds) = microseconds * this

/**
 * Multiply by a number of microseconds.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Long.times(microseconds: LongMicroseconds) = microseconds * this
