//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("YearsKt")
@file:OptIn(ExperimentalContracts::class)

package io.islandtime.measures

import dev.erikchristensen.javamath2kmp.absExact
import dev.erikchristensen.javamath2kmp.minusExact
import dev.erikchristensen.javamath2kmp.negateExact
import dev.erikchristensen.javamath2kmp.plusExact
import dev.erikchristensen.javamath2kmp.timesExact
import dev.erikchristensen.javamath2kmp.toIntExact
import io.islandtime.`internal`.MONTHS_PER_YEAR
import io.islandtime.`internal`.YEARS_PER_CENTURY
import io.islandtime.`internal`.YEARS_PER_DECADE
import io.islandtime.`internal`.deprecatedToError
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.OptIn
import kotlin.PublishedApi
import kotlin.String
import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract
import kotlin.jvm.JvmInline
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue

@Deprecated(
  message = "Replace with Years.",
  replaceWith = ReplaceWith("Years"),
  level = DeprecationLevel.ERROR
)
public typealias IntYears = Years

@Deprecated(
  message = "Replace with Years.",
  replaceWith = ReplaceWith("Years"),
  level = DeprecationLevel.ERROR
)
public typealias LongYears = Years

@JvmInline
public value class Years(
  /**
   * The underlying value.
   */
  public val `value`: Long
) : Comparable<Years> {
  /**
   * The absolute value of this duration. @throws ArithmeticException if overflow occurs
   */
  public val absoluteValue: Years
    get() = Years(absExact(value))

  /**
   * Converts this duration to months. @throws ArithmeticException if overflow occurs
   */
  public val inMonths: Months
    get() = Months(value timesExact MONTHS_PER_YEAR)

  /**
   * Converts this duration to months without checking for overflow.
   */
  internal val inMonthsUnchecked: Months
    get() = Months(value * MONTHS_PER_YEAR)

  /**
   * Converts this duration to the number of whole decades.
   */
  public val inWholeDecades: Decades
    get() = Decades(value / YEARS_PER_DECADE)

  @Deprecated(
    message = "Use inWholeDecades instead.",
    replaceWith = ReplaceWith("this.inWholeDecades"),
    level = DeprecationLevel.ERROR
  )
  public val inDecades: Decades
    get() = deprecatedToError()

  /**
   * Converts this duration to the number of whole centuries.
   */
  public val inWholeCenturies: Centuries
    get() = Centuries(value / YEARS_PER_CENTURY)

  @Deprecated(
    message = "Use inWholeCenturies instead.",
    replaceWith = ReplaceWith("this.inWholeCenturies"),
    level = DeprecationLevel.ERROR
  )
  public val inCenturies: Centuries
    get() = deprecatedToError()

  public constructor(`value`: Int) : this(value.toLong())

  /**
   * Checks if this duration is zero.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this == 0L.years"),
    level = DeprecationLevel.ERROR
  )
  public fun isZero(): Boolean = value == 0L

  /**
   * Checks if this duration is negative.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this < 0L.years"),
    level = DeprecationLevel.ERROR
  )
  public fun isNegative(): Boolean = value < 0L

  /**
   * Checks if this duration is positive.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this > 0L.years"),
    level = DeprecationLevel.ERROR
  )
  public fun isPositive(): Boolean = value > 0L

  public override fun compareTo(other: Years): Int = value.compareTo(other.value)

  /**
   * Converts this duration to an ISO-8601 time interval representation.
   */
  public override fun toString(): String {
     return when (value) {
       0L -> "P0Y"
       Long.MIN_VALUE -> "-P9223372036854775808Y"
       else -> buildString {
         if (value < 0) { append('-') }
         append("P")
         append(value.absoluteValue)
         append('Y')
       }
     }
  }

  /**
   * Negates this duration. @throws ArithmeticException if overflow occurs
   */
  public operator fun unaryMinus(): Years = Years(value.negateExact())

  /**
   * Negates this duration without checking for overflow.
   */
  internal fun negateUnchecked(): Years = Years(-value)

  public operator fun plus(months: Months): Months = this.inMonths + months

  public operator fun minus(months: Months): Months = this.inMonths - months

  public operator fun plus(years: Years): Years = Years(value plusExact years.value)

  public operator fun minus(years: Years): Years = Years(value minusExact years.value)

  public operator fun plus(decades: Decades): Years = this + decades.inYears

  public operator fun minus(decades: Decades): Years = this - decades.inYears

  public operator fun plus(centuries: Centuries): Years = this + centuries.inYears

  public operator fun minus(centuries: Centuries): Years = this - centuries.inYears

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Int): Years = Years(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Int): Years {
     return if (scalar == -1) {
       -this
     } else {
       Years(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Int): Years = Years(value % scalar)

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Long): Years = Years(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Long): Years {
     return if (scalar == -1L) {
       -this
     } else {
       Years(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Long): Years = Years(value % scalar)

  public inline fun <T> toComponentValues(action: (decades: Long, years: Int) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val decades = (value / YEARS_PER_DECADE)
    val years = (value % YEARS_PER_DECADE).toInt()
    return action(decades, years)
  }

  public inline fun <T> toComponents(action: (decades: Decades, years: Years) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { decades, years ->
         action(Decades(decades), Years(years))
     }
  }

  public inline fun <T> toComponentValues(action: (
    centuries: Long,
    decades: Int,
    years: Int
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val centuries = (value / YEARS_PER_CENTURY)
    val decades = ((value % YEARS_PER_CENTURY) / YEARS_PER_DECADE).toInt()
    val years = (value % YEARS_PER_DECADE).toInt()
    return action(centuries, decades, years)
  }

  public inline fun <T> toComponents(action: (
    centuries: Centuries,
    decades: Decades,
    years: Years
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { centuries, decades, years ->
         action(Centuries(centuries), Decades(decades), Years(years))
     }
  }

  /**
   * Converts this duration to an `Int` value. @throws ArithmeticException if overflow occurs
   */
  public fun toInt(): Int = value.toIntExact()

  /**
   * Converts this duration to an `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked(): Int = value.toInt()

  /**
   * Converts this duration to [IntYears]. @throws ArithmeticException if overflow occurs
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  public fun toIntYears(): Years = this

  /**
   * Converts this duration to [IntYears] without checking for overflow.
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  @PublishedApi
  internal fun toIntYearsUnchecked(): Years = this

  /**
   * Converts this duration to a `Long` value.
   */
  public fun toLong(): Long = value

  /**
   * Converts this duration to a `Double` value.
   */
  public fun toDouble(): Double = value.toDouble()

  public companion object {
    /**
     * The smallest supported value.
     */
    public val MIN: Years = Years(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    public val MAX: Years = Years(Long.MAX_VALUE)
  }
}

/**
 * Converts this value to a duration of years.
 */
public val Int.years: Years
  get() = Years(this)

/**
 * Multiplies this value by a duration of years. @throws ArithmeticException if overflow occurs
 */
public operator fun Int.times(years: Years): Years = years * this

/**
 * Converts this value to a duration of years.
 */
public val Long.years: Years
  get() = Years(this)

/**
 * Multiplies this value by a duration of years. @throws ArithmeticException if overflow occurs
 */
public operator fun Long.times(years: Years): Years = years * this
