//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("WeeksKt")
@file:OptIn(ExperimentalContracts::class)

package io.islandtime.measures

import dev.erikchristensen.javamath2kmp.absExact
import dev.erikchristensen.javamath2kmp.minusExact
import dev.erikchristensen.javamath2kmp.negateExact
import dev.erikchristensen.javamath2kmp.plusExact
import dev.erikchristensen.javamath2kmp.timesExact
import dev.erikchristensen.javamath2kmp.toIntExact
import io.islandtime.`internal`.DAYS_PER_WEEK
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.OptIn
import kotlin.PublishedApi
import kotlin.String
import kotlin.contracts.ExperimentalContracts
import kotlin.jvm.JvmInline
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue

@Deprecated(
  message = "Replace with Weeks.",
  replaceWith = ReplaceWith("Weeks"),
  level = DeprecationLevel.ERROR
)
public typealias IntWeeks = Weeks

@Deprecated(
  message = "Replace with Weeks.",
  replaceWith = ReplaceWith("Weeks"),
  level = DeprecationLevel.ERROR
)
public typealias LongWeeks = Weeks

@JvmInline
public value class Weeks(
  /**
   * The underlying value.
   */
  public val `value`: Long
) : Comparable<Weeks> {
  /**
   * The absolute value of this duration. @throws ArithmeticException if overflow occurs
   */
  public val absoluteValue: Weeks
    get() = Weeks(absExact(value))

  /**
   * Converts this duration to days. @throws ArithmeticException if overflow occurs
   */
  public val inDays: Days
    get() = Days(value timesExact DAYS_PER_WEEK)

  /**
   * Converts this duration to days without checking for overflow.
   */
  internal val inDaysUnchecked: Days
    get() = Days(value * DAYS_PER_WEEK)

  public constructor(`value`: Int) : this(value.toLong())

  /**
   * Checks if this duration is zero.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this == 0L.weeks"),
    level = DeprecationLevel.ERROR
  )
  public fun isZero(): Boolean = value == 0L

  /**
   * Checks if this duration is negative.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this < 0L.weeks"),
    level = DeprecationLevel.ERROR
  )
  public fun isNegative(): Boolean = value < 0L

  /**
   * Checks if this duration is positive.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this > 0L.weeks"),
    level = DeprecationLevel.ERROR
  )
  public fun isPositive(): Boolean = value > 0L

  public override fun compareTo(other: Weeks): Int = value.compareTo(other.value)

  /**
   * Converts this duration to an ISO-8601 time interval representation.
   */
  public override fun toString(): String {
     return when (value) {
       0L -> "P0W"
       Long.MIN_VALUE -> "-P9223372036854775808W"
       else -> buildString {
         if (value < 0) { append('-') }
         append("P")
         append(value.absoluteValue)
         append('W')
       }
     }
  }

  /**
   * Negates this duration. @throws ArithmeticException if overflow occurs
   */
  public operator fun unaryMinus(): Weeks = Weeks(value.negateExact())

  /**
   * Negates this duration without checking for overflow.
   */
  internal fun negateUnchecked(): Weeks = Weeks(-value)

  public operator fun plus(days: Days): Days = this.inDays + days

  public operator fun minus(days: Days): Days = this.inDays - days

  public operator fun plus(weeks: Weeks): Weeks = Weeks(value plusExact weeks.value)

  public operator fun minus(weeks: Weeks): Weeks = Weeks(value minusExact weeks.value)

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Int): Weeks = Weeks(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Int): Weeks {
     return if (scalar == -1) {
       -this
     } else {
       Weeks(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Int): Weeks = Weeks(value % scalar)

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Long): Weeks = Weeks(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Long): Weeks {
     return if (scalar == -1L) {
       -this
     } else {
       Weeks(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Long): Weeks = Weeks(value % scalar)

  /**
   * Converts this duration to an `Int` value. @throws ArithmeticException if overflow occurs
   */
  public fun toInt(): Int = value.toIntExact()

  /**
   * Converts this duration to an `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked(): Int = value.toInt()

  /**
   * Converts this duration to [IntWeeks]. @throws ArithmeticException if overflow occurs
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  public fun toIntWeeks(): Weeks = this

  /**
   * Converts this duration to [IntWeeks] without checking for overflow.
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  @PublishedApi
  internal fun toIntWeeksUnchecked(): Weeks = this

  /**
   * Converts this duration to a `Long` value.
   */
  public fun toLong(): Long = value

  /**
   * Converts this duration to a `Double` value.
   */
  public fun toDouble(): Double = value.toDouble()

  public companion object {
    /**
     * The smallest supported value.
     */
    public val MIN: Weeks = Weeks(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    public val MAX: Weeks = Weeks(Long.MAX_VALUE)
  }
}

/**
 * Converts this value to a duration of weeks.
 */
public val Int.weeks: Weeks
  get() = Weeks(this)

/**
 * Multiplies this value by a duration of weeks. @throws ArithmeticException if overflow occurs
 */
public operator fun Int.times(weeks: Weeks): Weeks = weeks * this

/**
 * Converts this value to a duration of weeks.
 */
public val Long.weeks: Weeks
  get() = Weeks(this)

/**
 * Multiplies this value by a duration of weeks. @throws ArithmeticException if overflow occurs
 */
public operator fun Long.times(weeks: Weeks): Weeks = weeks * this
