//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("SecondsKt")
@file:OptIn(ExperimentalContracts::class)

package io.islandtime.measures

import dev.erikchristensen.javamath2kmp.absExact
import dev.erikchristensen.javamath2kmp.minusExact
import dev.erikchristensen.javamath2kmp.negateExact
import dev.erikchristensen.javamath2kmp.plusExact
import dev.erikchristensen.javamath2kmp.timesExact
import dev.erikchristensen.javamath2kmp.toIntExact
import io.islandtime.`internal`.MICROSECONDS_PER_SECOND
import io.islandtime.`internal`.MILLISECONDS_PER_SECOND
import io.islandtime.`internal`.NANOSECONDS_PER_SECOND
import io.islandtime.`internal`.SECONDS_PER_DAY
import io.islandtime.`internal`.SECONDS_PER_HOUR
import io.islandtime.`internal`.SECONDS_PER_MINUTE
import io.islandtime.`internal`.deprecatedToError
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.OptIn
import kotlin.PublishedApi
import kotlin.String
import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract
import kotlin.jvm.JvmInline
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue
import kotlin.time.Duration.Companion.seconds as kotlinSeconds
import kotlin.time.DurationUnit as KotlinDurationUnit
import kotlin.time.Duration as KotlinDuration

@Deprecated(
  message = "Replace with Seconds.",
  replaceWith = ReplaceWith("Seconds"),
  level = DeprecationLevel.ERROR
)
public typealias IntSeconds = Seconds

@Deprecated(
  message = "Replace with Seconds.",
  replaceWith = ReplaceWith("Seconds"),
  level = DeprecationLevel.ERROR
)
public typealias LongSeconds = Seconds

@JvmInline
public value class Seconds(
  /**
   * The underlying value.
   */
  public val `value`: Long
) : Comparable<Seconds> {
  /**
   * The absolute value of this duration. @throws ArithmeticException if overflow occurs
   */
  public val absoluteValue: Seconds
    get() = Seconds(absExact(value))

  /**
   * Converts this duration to nanoseconds. @throws ArithmeticException if overflow occurs
   */
  public val inNanoseconds: Nanoseconds
    get() = Nanoseconds(value timesExact NANOSECONDS_PER_SECOND)

  /**
   * Converts this duration to nanoseconds without checking for overflow.
   */
  internal val inNanosecondsUnchecked: Nanoseconds
    get() = Nanoseconds(value * NANOSECONDS_PER_SECOND)

  /**
   * Converts this duration to microseconds. @throws ArithmeticException if overflow occurs
   */
  public val inMicroseconds: Microseconds
    get() = Microseconds(value timesExact MICROSECONDS_PER_SECOND)

  /**
   * Converts this duration to microseconds without checking for overflow.
   */
  internal val inMicrosecondsUnchecked: Microseconds
    get() = Microseconds(value * MICROSECONDS_PER_SECOND)

  /**
   * Converts this duration to milliseconds. @throws ArithmeticException if overflow occurs
   */
  public val inMilliseconds: Milliseconds
    get() = Milliseconds(value timesExact MILLISECONDS_PER_SECOND)

  /**
   * Converts this duration to milliseconds without checking for overflow.
   */
  internal val inMillisecondsUnchecked: Milliseconds
    get() = Milliseconds(value * MILLISECONDS_PER_SECOND)

  /**
   * Converts this duration to the number of whole minutes.
   */
  public val inWholeMinutes: Minutes
    get() = Minutes(value / SECONDS_PER_MINUTE)

  @Deprecated(
    message = "Use inWholeMinutes instead.",
    replaceWith = ReplaceWith("this.inWholeMinutes"),
    level = DeprecationLevel.ERROR
  )
  public val inMinutes: Minutes
    get() = deprecatedToError()

  /**
   * Converts this duration to the number of whole hours.
   */
  public val inWholeHours: Hours
    get() = Hours(value / SECONDS_PER_HOUR)

  @Deprecated(
    message = "Use inWholeHours instead.",
    replaceWith = ReplaceWith("this.inWholeHours"),
    level = DeprecationLevel.ERROR
  )
  public val inHours: Hours
    get() = deprecatedToError()

  /**
   * Converts this duration to the number of whole days.
   */
  public val inWholeDays: Days
    get() = Days(value / SECONDS_PER_DAY)

  @Deprecated(
    message = "Use inWholeDays instead.",
    replaceWith = ReplaceWith("this.inWholeDays"),
    level = DeprecationLevel.ERROR
  )
  public val inDays: Days
    get() = deprecatedToError()

  public constructor(`value`: Int) : this(value.toLong())

  /**
   * Checks if this duration is zero.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this == 0L.seconds"),
    level = DeprecationLevel.ERROR
  )
  public fun isZero(): Boolean = value == 0L

  /**
   * Checks if this duration is negative.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this < 0L.seconds"),
    level = DeprecationLevel.ERROR
  )
  public fun isNegative(): Boolean = value < 0L

  /**
   * Checks if this duration is positive.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this > 0L.seconds"),
    level = DeprecationLevel.ERROR
  )
  public fun isPositive(): Boolean = value > 0L

  public override fun compareTo(other: Seconds): Int = value.compareTo(other.value)

  /**
   * Converts this duration to a [kotlin.time.Duration].
   */
  public fun toKotlinDuration(): KotlinDuration = value.kotlinSeconds

  /**
   * Converts this duration to an ISO-8601 time interval representation.
   */
  public override fun toString(): String {
     return when (value) {
       0L -> "PT0S"
       Long.MIN_VALUE -> "-PT9223372036854775808S"
       else -> buildString {
         if (value < 0) { append('-') }
         append("PT")
         append(value.absoluteValue)
         append('S')
       }
     }
  }

  /**
   * Negates this duration. @throws ArithmeticException if overflow occurs
   */
  public operator fun unaryMinus(): Seconds = Seconds(value.negateExact())

  /**
   * Negates this duration without checking for overflow.
   */
  internal fun negateUnchecked(): Seconds = Seconds(-value)

  public operator fun plus(nanoseconds: Nanoseconds): Nanoseconds = this.inNanoseconds + nanoseconds

  public operator fun minus(nanoseconds: Nanoseconds): Nanoseconds = this.inNanoseconds -
      nanoseconds

  public operator fun plus(microseconds: Microseconds): Microseconds = this.inMicroseconds +
      microseconds

  public operator fun minus(microseconds: Microseconds): Microseconds = this.inMicroseconds -
      microseconds

  public operator fun plus(milliseconds: Milliseconds): Milliseconds = this.inMilliseconds +
      milliseconds

  public operator fun minus(milliseconds: Milliseconds): Milliseconds = this.inMilliseconds -
      milliseconds

  public operator fun plus(seconds: Seconds): Seconds = Seconds(value plusExact seconds.value)

  public operator fun minus(seconds: Seconds): Seconds = Seconds(value minusExact seconds.value)

  public operator fun plus(minutes: Minutes): Seconds = this + minutes.inSeconds

  public operator fun minus(minutes: Minutes): Seconds = this - minutes.inSeconds

  public operator fun plus(hours: Hours): Seconds = this + hours.inSeconds

  public operator fun minus(hours: Hours): Seconds = this - hours.inSeconds

  public operator fun plus(days: Days): Seconds = this + days.inSeconds

  public operator fun minus(days: Days): Seconds = this - days.inSeconds

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Int): Seconds = Seconds(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Int): Seconds {
     return if (scalar == -1) {
       -this
     } else {
       Seconds(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Int): Seconds = Seconds(value % scalar)

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Long): Seconds = Seconds(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Long): Seconds {
     return if (scalar == -1L) {
       -this
     } else {
       Seconds(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Long): Seconds = Seconds(value % scalar)

  public inline fun <T> toComponentValues(action: (minutes: Long, seconds: Int) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val minutes = (value / SECONDS_PER_MINUTE)
    val seconds = (value % SECONDS_PER_MINUTE).toInt()
    return action(minutes, seconds)
  }

  public inline fun <T> toComponents(action: (minutes: Minutes, seconds: Seconds) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { minutes, seconds ->
         action(Minutes(minutes), Seconds(seconds))
     }
  }

  public inline fun <T> toComponentValues(action: (
    hours: Long,
    minutes: Int,
    seconds: Int
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val hours = (value / SECONDS_PER_HOUR)
    val minutes = ((value % SECONDS_PER_HOUR) / SECONDS_PER_MINUTE).toInt()
    val seconds = (value % SECONDS_PER_MINUTE).toInt()
    return action(hours, minutes, seconds)
  }

  public inline fun <T> toComponents(action: (
    hours: Hours,
    minutes: Minutes,
    seconds: Seconds
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { hours, minutes, seconds ->
         action(Hours(hours), Minutes(minutes), Seconds(seconds))
     }
  }

  public inline fun <T> toComponentValues(action: (
    days: Long,
    hours: Int,
    minutes: Int,
    seconds: Int
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val days = (value / SECONDS_PER_DAY)
    val hours = ((value % SECONDS_PER_DAY) / SECONDS_PER_HOUR).toInt()
    val minutes = ((value % SECONDS_PER_HOUR) / SECONDS_PER_MINUTE).toInt()
    val seconds = (value % SECONDS_PER_MINUTE).toInt()
    return action(days, hours, minutes, seconds)
  }

  public inline fun <T> toComponents(action: (
    days: Days,
    hours: Hours,
    minutes: Minutes,
    seconds: Seconds
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { days, hours, minutes, seconds ->
         action(Days(days), Hours(hours), Minutes(minutes), Seconds(seconds))
     }
  }

  /**
   * Converts this duration to an `Int` value. @throws ArithmeticException if overflow occurs
   */
  public fun toInt(): Int = value.toIntExact()

  /**
   * Converts this duration to an `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked(): Int = value.toInt()

  /**
   * Converts this duration to [IntSeconds]. @throws ArithmeticException if overflow occurs
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  public fun toIntSeconds(): Seconds = this

  /**
   * Converts this duration to [IntSeconds] without checking for overflow.
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  @PublishedApi
  internal fun toIntSecondsUnchecked(): Seconds = this

  /**
   * Converts this duration to a `Long` value.
   */
  public fun toLong(): Long = value

  /**
   * Converts this duration to a `Double` value.
   */
  public fun toDouble(): Double = value.toDouble()

  public companion object {
    /**
     * The smallest supported value.
     */
    public val MIN: Seconds = Seconds(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    public val MAX: Seconds = Seconds(Long.MAX_VALUE)
  }
}

/**
 * Converts this value to a duration of seconds.
 */
public val Int.seconds: Seconds
  get() = Seconds(this)

/**
 * Multiplies this value by a duration of seconds. @throws ArithmeticException if overflow occurs
 */
public operator fun Int.times(seconds: Seconds): Seconds = seconds * this

/**
 * Converts this value to a duration of seconds.
 */
public val Long.seconds: Seconds
  get() = Seconds(this)

/**
 * Multiplies this value by a duration of seconds. @throws ArithmeticException if overflow occurs
 */
public operator fun Long.times(seconds: Seconds): Seconds = seconds * this

/**
 * Converts this duration to Island Time [Seconds].
 */
public fun KotlinDuration.toIslandSeconds(): Seconds =
    Seconds(this.toLong(KotlinDurationUnit.SECONDS))
