//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("MillisecondsKt")
@file:OptIn(ExperimentalContracts::class)

package io.islandtime.measures

import dev.erikchristensen.javamath2kmp.absExact
import dev.erikchristensen.javamath2kmp.minusExact
import dev.erikchristensen.javamath2kmp.negateExact
import dev.erikchristensen.javamath2kmp.plusExact
import dev.erikchristensen.javamath2kmp.timesExact
import dev.erikchristensen.javamath2kmp.toIntExact
import io.islandtime.`internal`.MICROSECONDS_PER_MILLISECOND
import io.islandtime.`internal`.MILLISECONDS_PER_DAY
import io.islandtime.`internal`.MILLISECONDS_PER_HOUR
import io.islandtime.`internal`.MILLISECONDS_PER_MINUTE
import io.islandtime.`internal`.MILLISECONDS_PER_SECOND
import io.islandtime.`internal`.NANOSECONDS_PER_MILLISECOND
import io.islandtime.`internal`.deprecatedToError
import io.islandtime.`internal`.toZeroPaddedString
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.OptIn
import kotlin.PublishedApi
import kotlin.String
import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract
import kotlin.jvm.JvmInline
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue
import kotlin.time.Duration.Companion.milliseconds as kotlinMilliseconds
import kotlin.time.DurationUnit as KotlinDurationUnit
import kotlin.time.Duration as KotlinDuration

@Deprecated(
  message = "Replace with Milliseconds.",
  replaceWith = ReplaceWith("Milliseconds"),
  level = DeprecationLevel.ERROR
)
public typealias IntMilliseconds = Milliseconds

@Deprecated(
  message = "Replace with Milliseconds.",
  replaceWith = ReplaceWith("Milliseconds"),
  level = DeprecationLevel.ERROR
)
public typealias LongMilliseconds = Milliseconds

@JvmInline
public value class Milliseconds(
  /**
   * The underlying value.
   */
  public val `value`: Long
) : Comparable<Milliseconds> {
  /**
   * The absolute value of this duration. @throws ArithmeticException if overflow occurs
   */
  public val absoluteValue: Milliseconds
    get() = Milliseconds(absExact(value))

  /**
   * Converts this duration to nanoseconds. @throws ArithmeticException if overflow occurs
   */
  public val inNanoseconds: Nanoseconds
    get() = Nanoseconds(value timesExact NANOSECONDS_PER_MILLISECOND)

  /**
   * Converts this duration to nanoseconds without checking for overflow.
   */
  internal val inNanosecondsUnchecked: Nanoseconds
    get() = Nanoseconds(value * NANOSECONDS_PER_MILLISECOND)

  /**
   * Converts this duration to microseconds. @throws ArithmeticException if overflow occurs
   */
  public val inMicroseconds: Microseconds
    get() = Microseconds(value timesExact MICROSECONDS_PER_MILLISECOND)

  /**
   * Converts this duration to microseconds without checking for overflow.
   */
  internal val inMicrosecondsUnchecked: Microseconds
    get() = Microseconds(value * MICROSECONDS_PER_MILLISECOND)

  /**
   * Converts this duration to the number of whole seconds.
   */
  public val inWholeSeconds: Seconds
    get() = Seconds(value / MILLISECONDS_PER_SECOND)

  @Deprecated(
    message = "Use inWholeSeconds instead.",
    replaceWith = ReplaceWith("this.inWholeSeconds"),
    level = DeprecationLevel.ERROR
  )
  public val inSeconds: Seconds
    get() = deprecatedToError()

  /**
   * Converts this duration to the number of whole minutes.
   */
  public val inWholeMinutes: Minutes
    get() = Minutes(value / MILLISECONDS_PER_MINUTE)

  @Deprecated(
    message = "Use inWholeMinutes instead.",
    replaceWith = ReplaceWith("this.inWholeMinutes"),
    level = DeprecationLevel.ERROR
  )
  public val inMinutes: Minutes
    get() = deprecatedToError()

  /**
   * Converts this duration to the number of whole hours.
   */
  public val inWholeHours: Hours
    get() = Hours(value / MILLISECONDS_PER_HOUR)

  @Deprecated(
    message = "Use inWholeHours instead.",
    replaceWith = ReplaceWith("this.inWholeHours"),
    level = DeprecationLevel.ERROR
  )
  public val inHours: Hours
    get() = deprecatedToError()

  /**
   * Converts this duration to the number of whole days.
   */
  public val inWholeDays: Days
    get() = Days(value / MILLISECONDS_PER_DAY)

  @Deprecated(
    message = "Use inWholeDays instead.",
    replaceWith = ReplaceWith("this.inWholeDays"),
    level = DeprecationLevel.ERROR
  )
  public val inDays: Days
    get() = deprecatedToError()

  public constructor(`value`: Int) : this(value.toLong())

  /**
   * Checks if this duration is zero.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this == 0L.milliseconds"),
    level = DeprecationLevel.ERROR
  )
  public fun isZero(): Boolean = value == 0L

  /**
   * Checks if this duration is negative.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this < 0L.milliseconds"),
    level = DeprecationLevel.ERROR
  )
  public fun isNegative(): Boolean = value < 0L

  /**
   * Checks if this duration is positive.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this > 0L.milliseconds"),
    level = DeprecationLevel.ERROR
  )
  public fun isPositive(): Boolean = value > 0L

  public override fun compareTo(other: Milliseconds): Int = value.compareTo(other.value)

  /**
   * Converts this duration to a [kotlin.time.Duration].
   */
  public fun toKotlinDuration(): KotlinDuration = value.kotlinMilliseconds

  /**
   * Converts this duration to an ISO-8601 time interval representation.
   */
  public override fun toString(): String {
     return if (value == 0L) {
       "PT0S"
     } else {
       buildString {
         val wholePart = (value / 1000).absoluteValue
         val fractionalPart = (value % 1000).toInt().absoluteValue
         if (value < 0) { append('-') }
         append("PT")
         append(wholePart)
         if (fractionalPart > 0) {
           append('.')
           append(fractionalPart.toZeroPaddedString(3).dropLastWhile { it == '0' })
         }
         append('S')
       }
     }
  }

  /**
   * Negates this duration. @throws ArithmeticException if overflow occurs
   */
  public operator fun unaryMinus(): Milliseconds = Milliseconds(value.negateExact())

  /**
   * Negates this duration without checking for overflow.
   */
  internal fun negateUnchecked(): Milliseconds = Milliseconds(-value)

  public operator fun plus(nanoseconds: Nanoseconds): Nanoseconds = this.inNanoseconds + nanoseconds

  public operator fun minus(nanoseconds: Nanoseconds): Nanoseconds = this.inNanoseconds -
      nanoseconds

  public operator fun plus(microseconds: Microseconds): Microseconds = this.inMicroseconds +
      microseconds

  public operator fun minus(microseconds: Microseconds): Microseconds = this.inMicroseconds -
      microseconds

  public operator fun plus(milliseconds: Milliseconds): Milliseconds = Milliseconds(value plusExact
      milliseconds.value)

  public operator fun minus(milliseconds: Milliseconds): Milliseconds =
      Milliseconds(value minusExact milliseconds.value)

  public operator fun plus(seconds: Seconds): Milliseconds = this + seconds.inMilliseconds

  public operator fun minus(seconds: Seconds): Milliseconds = this - seconds.inMilliseconds

  public operator fun plus(minutes: Minutes): Milliseconds = this + minutes.inMilliseconds

  public operator fun minus(minutes: Minutes): Milliseconds = this - minutes.inMilliseconds

  public operator fun plus(hours: Hours): Milliseconds = this + hours.inMilliseconds

  public operator fun minus(hours: Hours): Milliseconds = this - hours.inMilliseconds

  public operator fun plus(days: Days): Milliseconds = this + days.inMilliseconds

  public operator fun minus(days: Days): Milliseconds = this - days.inMilliseconds

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Int): Milliseconds = Milliseconds(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Int): Milliseconds {
     return if (scalar == -1) {
       -this
     } else {
       Milliseconds(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Int): Milliseconds = Milliseconds(value % scalar)

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Long): Milliseconds = Milliseconds(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Long): Milliseconds {
     return if (scalar == -1L) {
       -this
     } else {
       Milliseconds(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Long): Milliseconds = Milliseconds(value % scalar)

  public inline fun <T> toComponentValues(action: (seconds: Long, milliseconds: Int) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val seconds = (value / MILLISECONDS_PER_SECOND)
    val milliseconds = (value % MILLISECONDS_PER_SECOND).toInt()
    return action(seconds, milliseconds)
  }

  public inline fun <T> toComponents(action: (seconds: Seconds, milliseconds: Milliseconds) -> T):
      T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { seconds, milliseconds ->
         action(Seconds(seconds), Milliseconds(milliseconds))
     }
  }

  public inline fun <T> toComponentValues(action: (
    minutes: Long,
    seconds: Int,
    milliseconds: Int
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val minutes = (value / MILLISECONDS_PER_MINUTE)
    val seconds = ((value % MILLISECONDS_PER_MINUTE) / MILLISECONDS_PER_SECOND).toInt()
    val milliseconds = (value % MILLISECONDS_PER_SECOND).toInt()
    return action(minutes, seconds, milliseconds)
  }

  public inline fun <T> toComponents(action: (
    minutes: Minutes,
    seconds: Seconds,
    milliseconds: Milliseconds
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { minutes, seconds, milliseconds ->
         action(Minutes(minutes), Seconds(seconds), Milliseconds(milliseconds))
     }
  }

  public inline fun <T> toComponentValues(action: (
    hours: Long,
    minutes: Int,
    seconds: Int,
    milliseconds: Int
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val hours = (value / MILLISECONDS_PER_HOUR)
    val minutes = ((value % MILLISECONDS_PER_HOUR) / MILLISECONDS_PER_MINUTE).toInt()
    val seconds = ((value % MILLISECONDS_PER_MINUTE) / MILLISECONDS_PER_SECOND).toInt()
    val milliseconds = (value % MILLISECONDS_PER_SECOND).toInt()
    return action(hours, minutes, seconds, milliseconds)
  }

  public inline fun <T> toComponents(action: (
    hours: Hours,
    minutes: Minutes,
    seconds: Seconds,
    milliseconds: Milliseconds
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { hours, minutes, seconds, milliseconds ->
         action(Hours(hours), Minutes(minutes), Seconds(seconds), Milliseconds(milliseconds))
     }
  }

  public inline fun <T> toComponentValues(action: (
    days: Long,
    hours: Int,
    minutes: Int,
    seconds: Int,
    milliseconds: Int
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val days = (value / MILLISECONDS_PER_DAY)
    val hours = ((value % MILLISECONDS_PER_DAY) / MILLISECONDS_PER_HOUR).toInt()
    val minutes = ((value % MILLISECONDS_PER_HOUR) / MILLISECONDS_PER_MINUTE).toInt()
    val seconds = ((value % MILLISECONDS_PER_MINUTE) / MILLISECONDS_PER_SECOND).toInt()
    val milliseconds = (value % MILLISECONDS_PER_SECOND).toInt()
    return action(days, hours, minutes, seconds, milliseconds)
  }

  public inline fun <T> toComponents(action: (
    days: Days,
    hours: Hours,
    minutes: Minutes,
    seconds: Seconds,
    milliseconds: Milliseconds
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { days, hours, minutes, seconds, milliseconds ->
         action(Days(days), Hours(hours), Minutes(minutes), Seconds(seconds),
        Milliseconds(milliseconds))
     }
  }

  /**
   * Converts this duration to an `Int` value. @throws ArithmeticException if overflow occurs
   */
  public fun toInt(): Int = value.toIntExact()

  /**
   * Converts this duration to an `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked(): Int = value.toInt()

  /**
   * Converts this duration to [IntMilliseconds]. @throws ArithmeticException if overflow occurs
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  public fun toIntMilliseconds(): Milliseconds = this

  /**
   * Converts this duration to [IntMilliseconds] without checking for overflow.
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  @PublishedApi
  internal fun toIntMillisecondsUnchecked(): Milliseconds = this

  /**
   * Converts this duration to a `Long` value.
   */
  public fun toLong(): Long = value

  /**
   * Converts this duration to a `Double` value.
   */
  public fun toDouble(): Double = value.toDouble()

  public companion object {
    /**
     * The smallest supported value.
     */
    public val MIN: Milliseconds = Milliseconds(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    public val MAX: Milliseconds = Milliseconds(Long.MAX_VALUE)
  }
}

/**
 * Converts this value to a duration of milliseconds.
 */
public val Int.milliseconds: Milliseconds
  get() = Milliseconds(this)

/**
 * Multiplies this value by a duration of milliseconds. @throws ArithmeticException if overflow
 * occurs
 */
public operator fun Int.times(milliseconds: Milliseconds): Milliseconds = milliseconds * this

/**
 * Converts this value to a duration of milliseconds.
 */
public val Long.milliseconds: Milliseconds
  get() = Milliseconds(this)

/**
 * Multiplies this value by a duration of milliseconds. @throws ArithmeticException if overflow
 * occurs
 */
public operator fun Long.times(milliseconds: Milliseconds): Milliseconds = milliseconds * this

/**
 * Converts this duration to Island Time [Milliseconds].
 */
public fun KotlinDuration.toIslandMilliseconds(): Milliseconds =
    Milliseconds(this.toLong(KotlinDurationUnit.MILLISECONDS))
