//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("MicrosecondsKt")
@file:OptIn(ExperimentalContracts::class)

package io.islandtime.measures

import dev.erikchristensen.javamath2kmp.absExact
import dev.erikchristensen.javamath2kmp.minusExact
import dev.erikchristensen.javamath2kmp.negateExact
import dev.erikchristensen.javamath2kmp.plusExact
import dev.erikchristensen.javamath2kmp.timesExact
import dev.erikchristensen.javamath2kmp.toIntExact
import io.islandtime.`internal`.MICROSECONDS_PER_DAY
import io.islandtime.`internal`.MICROSECONDS_PER_HOUR
import io.islandtime.`internal`.MICROSECONDS_PER_MILLISECOND
import io.islandtime.`internal`.MICROSECONDS_PER_MINUTE
import io.islandtime.`internal`.MICROSECONDS_PER_SECOND
import io.islandtime.`internal`.NANOSECONDS_PER_MICROSECOND
import io.islandtime.`internal`.deprecatedToError
import io.islandtime.`internal`.toZeroPaddedString
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.OptIn
import kotlin.PublishedApi
import kotlin.String
import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract
import kotlin.jvm.JvmInline
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue
import kotlin.time.Duration.Companion.microseconds as kotlinMicroseconds
import kotlin.time.DurationUnit as KotlinDurationUnit
import kotlin.time.Duration as KotlinDuration

@Deprecated(
  message = "Replace with Microseconds.",
  replaceWith = ReplaceWith("Microseconds"),
  level = DeprecationLevel.ERROR
)
public typealias IntMicroseconds = Microseconds

@Deprecated(
  message = "Replace with Microseconds.",
  replaceWith = ReplaceWith("Microseconds"),
  level = DeprecationLevel.ERROR
)
public typealias LongMicroseconds = Microseconds

@JvmInline
public value class Microseconds(
  /**
   * The underlying value.
   */
  public val `value`: Long
) : Comparable<Microseconds> {
  /**
   * The absolute value of this duration. @throws ArithmeticException if overflow occurs
   */
  public val absoluteValue: Microseconds
    get() = Microseconds(absExact(value))

  /**
   * Converts this duration to nanoseconds. @throws ArithmeticException if overflow occurs
   */
  public val inNanoseconds: Nanoseconds
    get() = Nanoseconds(value timesExact NANOSECONDS_PER_MICROSECOND)

  /**
   * Converts this duration to nanoseconds without checking for overflow.
   */
  internal val inNanosecondsUnchecked: Nanoseconds
    get() = Nanoseconds(value * NANOSECONDS_PER_MICROSECOND)

  /**
   * Converts this duration to the number of whole milliseconds.
   */
  public val inWholeMilliseconds: Milliseconds
    get() = Milliseconds(value / MICROSECONDS_PER_MILLISECOND)

  @Deprecated(
    message = "Use inWholeMilliseconds instead.",
    replaceWith = ReplaceWith("this.inWholeMilliseconds"),
    level = DeprecationLevel.ERROR
  )
  public val inMilliseconds: Milliseconds
    get() = deprecatedToError()

  /**
   * Converts this duration to the number of whole seconds.
   */
  public val inWholeSeconds: Seconds
    get() = Seconds(value / MICROSECONDS_PER_SECOND)

  @Deprecated(
    message = "Use inWholeSeconds instead.",
    replaceWith = ReplaceWith("this.inWholeSeconds"),
    level = DeprecationLevel.ERROR
  )
  public val inSeconds: Seconds
    get() = deprecatedToError()

  /**
   * Converts this duration to the number of whole minutes.
   */
  public val inWholeMinutes: Minutes
    get() = Minutes(value / MICROSECONDS_PER_MINUTE)

  @Deprecated(
    message = "Use inWholeMinutes instead.",
    replaceWith = ReplaceWith("this.inWholeMinutes"),
    level = DeprecationLevel.ERROR
  )
  public val inMinutes: Minutes
    get() = deprecatedToError()

  /**
   * Converts this duration to the number of whole hours.
   */
  public val inWholeHours: Hours
    get() = Hours(value / MICROSECONDS_PER_HOUR)

  @Deprecated(
    message = "Use inWholeHours instead.",
    replaceWith = ReplaceWith("this.inWholeHours"),
    level = DeprecationLevel.ERROR
  )
  public val inHours: Hours
    get() = deprecatedToError()

  /**
   * Converts this duration to the number of whole days.
   */
  public val inWholeDays: Days
    get() = Days(value / MICROSECONDS_PER_DAY)

  @Deprecated(
    message = "Use inWholeDays instead.",
    replaceWith = ReplaceWith("this.inWholeDays"),
    level = DeprecationLevel.ERROR
  )
  public val inDays: Days
    get() = deprecatedToError()

  public constructor(`value`: Int) : this(value.toLong())

  /**
   * Checks if this duration is zero.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this == 0L.microseconds"),
    level = DeprecationLevel.ERROR
  )
  public fun isZero(): Boolean = value == 0L

  /**
   * Checks if this duration is negative.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this < 0L.microseconds"),
    level = DeprecationLevel.ERROR
  )
  public fun isNegative(): Boolean = value < 0L

  /**
   * Checks if this duration is positive.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this > 0L.microseconds"),
    level = DeprecationLevel.ERROR
  )
  public fun isPositive(): Boolean = value > 0L

  public override fun compareTo(other: Microseconds): Int = value.compareTo(other.value)

  /**
   * Converts this duration to a [kotlin.time.Duration].
   */
  public fun toKotlinDuration(): KotlinDuration = value.kotlinMicroseconds

  /**
   * Converts this duration to an ISO-8601 time interval representation.
   */
  public override fun toString(): String {
     return if (value == 0L) {
       "PT0S"
     } else {
       buildString {
         val wholePart = (value / 1000000).absoluteValue
         val fractionalPart = (value % 1000000).toInt().absoluteValue
         if (value < 0) { append('-') }
         append("PT")
         append(wholePart)
         if (fractionalPart > 0) {
           append('.')
           append(fractionalPart.toZeroPaddedString(6).dropLastWhile { it == '0' })
         }
         append('S')
       }
     }
  }

  /**
   * Negates this duration. @throws ArithmeticException if overflow occurs
   */
  public operator fun unaryMinus(): Microseconds = Microseconds(value.negateExact())

  /**
   * Negates this duration without checking for overflow.
   */
  internal fun negateUnchecked(): Microseconds = Microseconds(-value)

  public operator fun plus(nanoseconds: Nanoseconds): Nanoseconds = this.inNanoseconds + nanoseconds

  public operator fun minus(nanoseconds: Nanoseconds): Nanoseconds = this.inNanoseconds -
      nanoseconds

  public operator fun plus(microseconds: Microseconds): Microseconds = Microseconds(value plusExact
      microseconds.value)

  public operator fun minus(microseconds: Microseconds): Microseconds =
      Microseconds(value minusExact microseconds.value)

  public operator fun plus(milliseconds: Milliseconds): Microseconds = this +
      milliseconds.inMicroseconds

  public operator fun minus(milliseconds: Milliseconds): Microseconds = this -
      milliseconds.inMicroseconds

  public operator fun plus(seconds: Seconds): Microseconds = this + seconds.inMicroseconds

  public operator fun minus(seconds: Seconds): Microseconds = this - seconds.inMicroseconds

  public operator fun plus(minutes: Minutes): Microseconds = this + minutes.inMicroseconds

  public operator fun minus(minutes: Minutes): Microseconds = this - minutes.inMicroseconds

  public operator fun plus(hours: Hours): Microseconds = this + hours.inMicroseconds

  public operator fun minus(hours: Hours): Microseconds = this - hours.inMicroseconds

  public operator fun plus(days: Days): Microseconds = this + days.inMicroseconds

  public operator fun minus(days: Days): Microseconds = this - days.inMicroseconds

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Int): Microseconds = Microseconds(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Int): Microseconds {
     return if (scalar == -1) {
       -this
     } else {
       Microseconds(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Int): Microseconds = Microseconds(value % scalar)

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Long): Microseconds = Microseconds(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Long): Microseconds {
     return if (scalar == -1L) {
       -this
     } else {
       Microseconds(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Long): Microseconds = Microseconds(value % scalar)

  public inline fun <T> toComponentValues(action: (milliseconds: Long, microseconds: Int) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val milliseconds = (value / MICROSECONDS_PER_MILLISECOND)
    val microseconds = (value % MICROSECONDS_PER_MILLISECOND).toInt()
    return action(milliseconds, microseconds)
  }

  public inline fun <T> toComponents(action: (milliseconds: Milliseconds,
      microseconds: Microseconds) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { milliseconds, microseconds ->
         action(Milliseconds(milliseconds), Microseconds(microseconds))
     }
  }

  public inline fun <T> toComponentValues(action: (
    seconds: Long,
    milliseconds: Int,
    microseconds: Int
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val seconds = (value / MICROSECONDS_PER_SECOND)
    val milliseconds = ((value % MICROSECONDS_PER_SECOND) / MICROSECONDS_PER_MILLISECOND).toInt()
    val microseconds = (value % MICROSECONDS_PER_MILLISECOND).toInt()
    return action(seconds, milliseconds, microseconds)
  }

  public inline fun <T> toComponents(action: (
    seconds: Seconds,
    milliseconds: Milliseconds,
    microseconds: Microseconds
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { seconds, milliseconds, microseconds ->
         action(Seconds(seconds), Milliseconds(milliseconds), Microseconds(microseconds))
     }
  }

  public inline fun <T> toComponentValues(action: (
    minutes: Long,
    seconds: Int,
    milliseconds: Int,
    microseconds: Int
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val minutes = (value / MICROSECONDS_PER_MINUTE)
    val seconds = ((value % MICROSECONDS_PER_MINUTE) / MICROSECONDS_PER_SECOND).toInt()
    val milliseconds = ((value % MICROSECONDS_PER_SECOND) / MICROSECONDS_PER_MILLISECOND).toInt()
    val microseconds = (value % MICROSECONDS_PER_MILLISECOND).toInt()
    return action(minutes, seconds, milliseconds, microseconds)
  }

  public inline fun <T> toComponents(action: (
    minutes: Minutes,
    seconds: Seconds,
    milliseconds: Milliseconds,
    microseconds: Microseconds
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { minutes, seconds, milliseconds, microseconds ->
         action(Minutes(minutes), Seconds(seconds), Milliseconds(milliseconds),
        Microseconds(microseconds))
     }
  }

  public inline fun <T> toComponentValues(action: (
    hours: Long,
    minutes: Int,
    seconds: Int,
    milliseconds: Int,
    microseconds: Int
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val hours = (value / MICROSECONDS_PER_HOUR)
    val minutes = ((value % MICROSECONDS_PER_HOUR) / MICROSECONDS_PER_MINUTE).toInt()
    val seconds = ((value % MICROSECONDS_PER_MINUTE) / MICROSECONDS_PER_SECOND).toInt()
    val milliseconds = ((value % MICROSECONDS_PER_SECOND) / MICROSECONDS_PER_MILLISECOND).toInt()
    val microseconds = (value % MICROSECONDS_PER_MILLISECOND).toInt()
    return action(hours, minutes, seconds, milliseconds, microseconds)
  }

  public inline fun <T> toComponents(action: (
    hours: Hours,
    minutes: Minutes,
    seconds: Seconds,
    milliseconds: Milliseconds,
    microseconds: Microseconds
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { hours, minutes, seconds, milliseconds, microseconds ->
         action(Hours(hours), Minutes(minutes), Seconds(seconds), Milliseconds(milliseconds),
        Microseconds(microseconds))
     }
  }

  public inline fun <T> toComponentValues(action: (
    days: Long,
    hours: Int,
    minutes: Int,
    seconds: Int,
    milliseconds: Int,
    microseconds: Int
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val days = (value / MICROSECONDS_PER_DAY)
    val hours = ((value % MICROSECONDS_PER_DAY) / MICROSECONDS_PER_HOUR).toInt()
    val minutes = ((value % MICROSECONDS_PER_HOUR) / MICROSECONDS_PER_MINUTE).toInt()
    val seconds = ((value % MICROSECONDS_PER_MINUTE) / MICROSECONDS_PER_SECOND).toInt()
    val milliseconds = ((value % MICROSECONDS_PER_SECOND) / MICROSECONDS_PER_MILLISECOND).toInt()
    val microseconds = (value % MICROSECONDS_PER_MILLISECOND).toInt()
    return action(days, hours, minutes, seconds, milliseconds, microseconds)
  }

  public inline fun <T> toComponents(action: (
    days: Days,
    hours: Hours,
    minutes: Minutes,
    seconds: Seconds,
    milliseconds: Milliseconds,
    microseconds: Microseconds
  ) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { days, hours, minutes, seconds, milliseconds, microseconds ->
         action(Days(days), Hours(hours), Minutes(minutes), Seconds(seconds),
        Milliseconds(milliseconds), Microseconds(microseconds))
     }
  }

  /**
   * Converts this duration to an `Int` value. @throws ArithmeticException if overflow occurs
   */
  public fun toInt(): Int = value.toIntExact()

  /**
   * Converts this duration to an `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked(): Int = value.toInt()

  /**
   * Converts this duration to [IntMicroseconds]. @throws ArithmeticException if overflow occurs
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  public fun toIntMicroseconds(): Microseconds = this

  /**
   * Converts this duration to [IntMicroseconds] without checking for overflow.
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  @PublishedApi
  internal fun toIntMicrosecondsUnchecked(): Microseconds = this

  /**
   * Converts this duration to a `Long` value.
   */
  public fun toLong(): Long = value

  /**
   * Converts this duration to a `Double` value.
   */
  public fun toDouble(): Double = value.toDouble()

  public companion object {
    /**
     * The smallest supported value.
     */
    public val MIN: Microseconds = Microseconds(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    public val MAX: Microseconds = Microseconds(Long.MAX_VALUE)
  }
}

/**
 * Converts this value to a duration of microseconds.
 */
public val Int.microseconds: Microseconds
  get() = Microseconds(this)

/**
 * Multiplies this value by a duration of microseconds. @throws ArithmeticException if overflow
 * occurs
 */
public operator fun Int.times(microseconds: Microseconds): Microseconds = microseconds * this

/**
 * Converts this value to a duration of microseconds.
 */
public val Long.microseconds: Microseconds
  get() = Microseconds(this)

/**
 * Multiplies this value by a duration of microseconds. @throws ArithmeticException if overflow
 * occurs
 */
public operator fun Long.times(microseconds: Microseconds): Microseconds = microseconds * this

/**
 * Converts this duration to Island Time [Microseconds].
 */
public fun KotlinDuration.toIslandMicroseconds(): Microseconds =
    Microseconds(this.toLong(KotlinDurationUnit.MICROSECONDS))
