//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("DecadesKt")
@file:OptIn(ExperimentalContracts::class)

package io.islandtime.measures

import dev.erikchristensen.javamath2kmp.absExact
import dev.erikchristensen.javamath2kmp.minusExact
import dev.erikchristensen.javamath2kmp.negateExact
import dev.erikchristensen.javamath2kmp.plusExact
import dev.erikchristensen.javamath2kmp.timesExact
import dev.erikchristensen.javamath2kmp.toIntExact
import io.islandtime.`internal`.DECADES_PER_CENTURY
import io.islandtime.`internal`.MONTHS_PER_DECADE
import io.islandtime.`internal`.YEARS_PER_DECADE
import io.islandtime.`internal`.deprecatedToError
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.OptIn
import kotlin.PublishedApi
import kotlin.String
import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract
import kotlin.jvm.JvmInline
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue

@Deprecated(
  message = "Replace with Decades.",
  replaceWith = ReplaceWith("Decades"),
  level = DeprecationLevel.ERROR
)
public typealias IntDecades = Decades

@Deprecated(
  message = "Replace with Decades.",
  replaceWith = ReplaceWith("Decades"),
  level = DeprecationLevel.ERROR
)
public typealias LongDecades = Decades

@JvmInline
public value class Decades(
  /**
   * The underlying value.
   */
  public val `value`: Long
) : Comparable<Decades> {
  /**
   * The absolute value of this duration. @throws ArithmeticException if overflow occurs
   */
  public val absoluteValue: Decades
    get() = Decades(absExact(value))

  /**
   * Converts this duration to months. @throws ArithmeticException if overflow occurs
   */
  public val inMonths: Months
    get() = Months(value timesExact MONTHS_PER_DECADE)

  /**
   * Converts this duration to months without checking for overflow.
   */
  internal val inMonthsUnchecked: Months
    get() = Months(value * MONTHS_PER_DECADE)

  /**
   * Converts this duration to years. @throws ArithmeticException if overflow occurs
   */
  public val inYears: Years
    get() = Years(value timesExact YEARS_PER_DECADE)

  /**
   * Converts this duration to years without checking for overflow.
   */
  internal val inYearsUnchecked: Years
    get() = Years(value * YEARS_PER_DECADE)

  /**
   * Converts this duration to the number of whole centuries.
   */
  public val inWholeCenturies: Centuries
    get() = Centuries(value / DECADES_PER_CENTURY)

  @Deprecated(
    message = "Use inWholeCenturies instead.",
    replaceWith = ReplaceWith("this.inWholeCenturies"),
    level = DeprecationLevel.ERROR
  )
  public val inCenturies: Centuries
    get() = deprecatedToError()

  public constructor(`value`: Int) : this(value.toLong())

  /**
   * Checks if this duration is zero.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this == 0L.decades"),
    level = DeprecationLevel.ERROR
  )
  public fun isZero(): Boolean = value == 0L

  /**
   * Checks if this duration is negative.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this < 0L.decades"),
    level = DeprecationLevel.ERROR
  )
  public fun isNegative(): Boolean = value < 0L

  /**
   * Checks if this duration is positive.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this > 0L.decades"),
    level = DeprecationLevel.ERROR
  )
  public fun isPositive(): Boolean = value > 0L

  public override fun compareTo(other: Decades): Int = value.compareTo(other.value)

  /**
   * Converts this duration to an ISO-8601 time interval representation.
   */
  public override fun toString(): String {
     return when (value) {
       0L -> "P0Y"
       Long.MIN_VALUE -> "-P9223372036854775808Y"
       else -> buildString {
         if (value < 0) { append('-') }
         append("P")
         append(value.absoluteValue timesExact 10)
         append('Y')
       }
     }
  }

  /**
   * Negates this duration. @throws ArithmeticException if overflow occurs
   */
  public operator fun unaryMinus(): Decades = Decades(value.negateExact())

  /**
   * Negates this duration without checking for overflow.
   */
  internal fun negateUnchecked(): Decades = Decades(-value)

  public operator fun plus(months: Months): Months = this.inMonths + months

  public operator fun minus(months: Months): Months = this.inMonths - months

  public operator fun plus(years: Years): Years = this.inYears + years

  public operator fun minus(years: Years): Years = this.inYears - years

  public operator fun plus(decades: Decades): Decades = Decades(value plusExact decades.value)

  public operator fun minus(decades: Decades): Decades = Decades(value minusExact decades.value)

  public operator fun plus(centuries: Centuries): Decades = this + centuries.inDecades

  public operator fun minus(centuries: Centuries): Decades = this - centuries.inDecades

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Int): Decades = Decades(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Int): Decades {
     return if (scalar == -1) {
       -this
     } else {
       Decades(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Int): Decades = Decades(value % scalar)

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Long): Decades = Decades(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Long): Decades {
     return if (scalar == -1L) {
       -this
     } else {
       Decades(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Long): Decades = Decades(value % scalar)

  public inline fun <T> toComponentValues(action: (centuries: Long, decades: Int) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val centuries = (value / DECADES_PER_CENTURY)
    val decades = (value % DECADES_PER_CENTURY).toInt()
    return action(centuries, decades)
  }

  public inline fun <T> toComponents(action: (centuries: Centuries, decades: Decades) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { centuries, decades ->
         action(Centuries(centuries), Decades(decades))
     }
  }

  /**
   * Converts this duration to an `Int` value. @throws ArithmeticException if overflow occurs
   */
  public fun toInt(): Int = value.toIntExact()

  /**
   * Converts this duration to an `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked(): Int = value.toInt()

  /**
   * Converts this duration to [IntDecades]. @throws ArithmeticException if overflow occurs
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  public fun toIntDecades(): Decades = this

  /**
   * Converts this duration to [IntDecades] without checking for overflow.
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  @PublishedApi
  internal fun toIntDecadesUnchecked(): Decades = this

  /**
   * Converts this duration to a `Long` value.
   */
  public fun toLong(): Long = value

  /**
   * Converts this duration to a `Double` value.
   */
  public fun toDouble(): Double = value.toDouble()

  public companion object {
    /**
     * The smallest supported value.
     */
    public val MIN: Decades = Decades(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    public val MAX: Decades = Decades(Long.MAX_VALUE)
  }
}

/**
 * Converts this value to a duration of decades.
 */
public val Int.decades: Decades
  get() = Decades(this)

/**
 * Multiplies this value by a duration of decades. @throws ArithmeticException if overflow occurs
 */
public operator fun Int.times(decades: Decades): Decades = decades * this

/**
 * Converts this value to a duration of decades.
 */
public val Long.decades: Decades
  get() = Decades(this)

/**
 * Multiplies this value by a duration of decades. @throws ArithmeticException if overflow occurs
 */
public operator fun Long.times(decades: Decades): Decades = decades * this
