//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("DaysKt")
@file:OptIn(ExperimentalContracts::class)

package io.islandtime.measures

import dev.erikchristensen.javamath2kmp.absExact
import dev.erikchristensen.javamath2kmp.minusExact
import dev.erikchristensen.javamath2kmp.negateExact
import dev.erikchristensen.javamath2kmp.plusExact
import dev.erikchristensen.javamath2kmp.timesExact
import dev.erikchristensen.javamath2kmp.toIntExact
import io.islandtime.`internal`.DAYS_PER_WEEK
import io.islandtime.`internal`.HOURS_PER_DAY
import io.islandtime.`internal`.MICROSECONDS_PER_DAY
import io.islandtime.`internal`.MILLISECONDS_PER_DAY
import io.islandtime.`internal`.MINUTES_PER_DAY
import io.islandtime.`internal`.NANOSECONDS_PER_DAY
import io.islandtime.`internal`.SECONDS_PER_DAY
import io.islandtime.`internal`.deprecatedToError
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.OptIn
import kotlin.PublishedApi
import kotlin.String
import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract
import kotlin.jvm.JvmInline
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue
import kotlin.time.Duration.Companion.days as kotlinDays
import kotlin.time.DurationUnit as KotlinDurationUnit
import kotlin.time.Duration as KotlinDuration

@Deprecated(
  message = "Replace with Days.",
  replaceWith = ReplaceWith("Days"),
  level = DeprecationLevel.ERROR
)
public typealias IntDays = Days

@Deprecated(
  message = "Replace with Days.",
  replaceWith = ReplaceWith("Days"),
  level = DeprecationLevel.ERROR
)
public typealias LongDays = Days

@JvmInline
public value class Days(
  /**
   * The underlying value.
   */
  public val `value`: Long
) : Comparable<Days> {
  /**
   * The absolute value of this duration. @throws ArithmeticException if overflow occurs
   */
  public val absoluteValue: Days
    get() = Days(absExact(value))

  /**
   * Converts this duration to nanoseconds. @throws ArithmeticException if overflow occurs
   */
  public val inNanoseconds: Nanoseconds
    get() = Nanoseconds(value timesExact NANOSECONDS_PER_DAY)

  /**
   * Converts this duration to nanoseconds without checking for overflow.
   */
  internal val inNanosecondsUnchecked: Nanoseconds
    get() = Nanoseconds(value * NANOSECONDS_PER_DAY)

  /**
   * Converts this duration to microseconds. @throws ArithmeticException if overflow occurs
   */
  public val inMicroseconds: Microseconds
    get() = Microseconds(value timesExact MICROSECONDS_PER_DAY)

  /**
   * Converts this duration to microseconds without checking for overflow.
   */
  internal val inMicrosecondsUnchecked: Microseconds
    get() = Microseconds(value * MICROSECONDS_PER_DAY)

  /**
   * Converts this duration to milliseconds. @throws ArithmeticException if overflow occurs
   */
  public val inMilliseconds: Milliseconds
    get() = Milliseconds(value timesExact MILLISECONDS_PER_DAY)

  /**
   * Converts this duration to milliseconds without checking for overflow.
   */
  internal val inMillisecondsUnchecked: Milliseconds
    get() = Milliseconds(value * MILLISECONDS_PER_DAY)

  /**
   * Converts this duration to seconds. @throws ArithmeticException if overflow occurs
   */
  public val inSeconds: Seconds
    get() = Seconds(value timesExact SECONDS_PER_DAY)

  /**
   * Converts this duration to seconds without checking for overflow.
   */
  internal val inSecondsUnchecked: Seconds
    get() = Seconds(value * SECONDS_PER_DAY)

  /**
   * Converts this duration to minutes. @throws ArithmeticException if overflow occurs
   */
  public val inMinutes: Minutes
    get() = Minutes(value timesExact MINUTES_PER_DAY)

  /**
   * Converts this duration to minutes without checking for overflow.
   */
  internal val inMinutesUnchecked: Minutes
    get() = Minutes(value * MINUTES_PER_DAY)

  /**
   * Converts this duration to hours. @throws ArithmeticException if overflow occurs
   */
  public val inHours: Hours
    get() = Hours(value timesExact HOURS_PER_DAY)

  /**
   * Converts this duration to hours without checking for overflow.
   */
  internal val inHoursUnchecked: Hours
    get() = Hours(value * HOURS_PER_DAY)

  /**
   * Converts this duration to the number of whole weeks.
   */
  public val inWholeWeeks: Weeks
    get() = Weeks(value / DAYS_PER_WEEK)

  @Deprecated(
    message = "Use inWholeWeeks instead.",
    replaceWith = ReplaceWith("this.inWholeWeeks"),
    level = DeprecationLevel.ERROR
  )
  public val inWeeks: Weeks
    get() = deprecatedToError()

  public constructor(`value`: Int) : this(value.toLong())

  /**
   * Checks if this duration is zero.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this == 0L.days"),
    level = DeprecationLevel.ERROR
  )
  public fun isZero(): Boolean = value == 0L

  /**
   * Checks if this duration is negative.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this < 0L.days"),
    level = DeprecationLevel.ERROR
  )
  public fun isNegative(): Boolean = value < 0L

  /**
   * Checks if this duration is positive.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this > 0L.days"),
    level = DeprecationLevel.ERROR
  )
  public fun isPositive(): Boolean = value > 0L

  public override fun compareTo(other: Days): Int = value.compareTo(other.value)

  /**
   * Converts this duration to a [kotlin.time.Duration].
   */
  public fun toKotlinDuration(): KotlinDuration = value.kotlinDays

  /**
   * Converts this duration to an ISO-8601 time interval representation.
   */
  public override fun toString(): String {
     return when (value) {
       0L -> "P0D"
       Long.MIN_VALUE -> "-P9223372036854775808D"
       else -> buildString {
         if (value < 0) { append('-') }
         append("P")
         append(value.absoluteValue)
         append('D')
       }
     }
  }

  /**
   * Negates this duration. @throws ArithmeticException if overflow occurs
   */
  public operator fun unaryMinus(): Days = Days(value.negateExact())

  /**
   * Negates this duration without checking for overflow.
   */
  internal fun negateUnchecked(): Days = Days(-value)

  public operator fun plus(nanoseconds: Nanoseconds): Nanoseconds = this.inNanoseconds + nanoseconds

  public operator fun minus(nanoseconds: Nanoseconds): Nanoseconds = this.inNanoseconds -
      nanoseconds

  public operator fun plus(microseconds: Microseconds): Microseconds = this.inMicroseconds +
      microseconds

  public operator fun minus(microseconds: Microseconds): Microseconds = this.inMicroseconds -
      microseconds

  public operator fun plus(milliseconds: Milliseconds): Milliseconds = this.inMilliseconds +
      milliseconds

  public operator fun minus(milliseconds: Milliseconds): Milliseconds = this.inMilliseconds -
      milliseconds

  public operator fun plus(seconds: Seconds): Seconds = this.inSeconds + seconds

  public operator fun minus(seconds: Seconds): Seconds = this.inSeconds - seconds

  public operator fun plus(minutes: Minutes): Minutes = this.inMinutes + minutes

  public operator fun minus(minutes: Minutes): Minutes = this.inMinutes - minutes

  public operator fun plus(hours: Hours): Hours = this.inHours + hours

  public operator fun minus(hours: Hours): Hours = this.inHours - hours

  public operator fun plus(days: Days): Days = Days(value plusExact days.value)

  public operator fun minus(days: Days): Days = Days(value minusExact days.value)

  public operator fun plus(weeks: Weeks): Days = this + weeks.inDays

  public operator fun minus(weeks: Weeks): Days = this - weeks.inDays

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Int): Days = Days(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Int): Days {
     return if (scalar == -1) {
       -this
     } else {
       Days(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Int): Days = Days(value % scalar)

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Long): Days = Days(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Long): Days {
     return if (scalar == -1L) {
       -this
     } else {
       Days(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Long): Days = Days(value % scalar)

  public inline fun <T> toComponentValues(action: (weeks: Long, days: Int) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
    val weeks = (value / DAYS_PER_WEEK)
    val days = (value % DAYS_PER_WEEK).toInt()
    return action(weeks, days)
  }

  public inline fun <T> toComponents(action: (weeks: Weeks, days: Days) -> T): T {
    contract { callsInPlace(action, InvocationKind.EXACTLY_ONCE) }
     return toComponentValues { weeks, days ->
         action(Weeks(weeks), Days(days))
     }
  }

  /**
   * Converts this duration to an `Int` value. @throws ArithmeticException if overflow occurs
   */
  public fun toInt(): Int = value.toIntExact()

  /**
   * Converts this duration to an `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked(): Int = value.toInt()

  /**
   * Converts this duration to [IntDays]. @throws ArithmeticException if overflow occurs
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  public fun toIntDays(): Days = this

  /**
   * Converts this duration to [IntDays] without checking for overflow.
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  @PublishedApi
  internal fun toIntDaysUnchecked(): Days = this

  /**
   * Converts this duration to a `Long` value.
   */
  public fun toLong(): Long = value

  /**
   * Converts this duration to a `Double` value.
   */
  public fun toDouble(): Double = value.toDouble()

  public companion object {
    /**
     * The smallest supported value.
     */
    public val MIN: Days = Days(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    public val MAX: Days = Days(Long.MAX_VALUE)
  }
}

/**
 * Converts this value to a duration of days.
 */
public val Int.days: Days
  get() = Days(this)

/**
 * Multiplies this value by a duration of days. @throws ArithmeticException if overflow occurs
 */
public operator fun Int.times(days: Days): Days = days * this

/**
 * Converts this value to a duration of days.
 */
public val Long.days: Days
  get() = Days(this)

/**
 * Multiplies this value by a duration of days. @throws ArithmeticException if overflow occurs
 */
public operator fun Long.times(days: Days): Days = days * this

/**
 * Converts this duration to Island Time [Days].
 */
public fun KotlinDuration.toIslandDays(): Days = Days(this.toLong(KotlinDurationUnit.DAYS))
