//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("CenturiesKt")
@file:OptIn(ExperimentalContracts::class)

package io.islandtime.measures

import dev.erikchristensen.javamath2kmp.absExact
import dev.erikchristensen.javamath2kmp.minusExact
import dev.erikchristensen.javamath2kmp.negateExact
import dev.erikchristensen.javamath2kmp.plusExact
import dev.erikchristensen.javamath2kmp.timesExact
import dev.erikchristensen.javamath2kmp.toIntExact
import io.islandtime.`internal`.DECADES_PER_CENTURY
import io.islandtime.`internal`.MONTHS_PER_CENTURY
import io.islandtime.`internal`.YEARS_PER_CENTURY
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.OptIn
import kotlin.PublishedApi
import kotlin.String
import kotlin.contracts.ExperimentalContracts
import kotlin.jvm.JvmInline
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue

@Deprecated(
  message = "Replace with Centuries.",
  replaceWith = ReplaceWith("Centuries"),
  level = DeprecationLevel.ERROR
)
public typealias IntCenturies = Centuries

@Deprecated(
  message = "Replace with Centuries.",
  replaceWith = ReplaceWith("Centuries"),
  level = DeprecationLevel.ERROR
)
public typealias LongCenturies = Centuries

@JvmInline
public value class Centuries(
  /**
   * The underlying value.
   */
  public val `value`: Long
) : Comparable<Centuries> {
  /**
   * The absolute value of this duration. @throws ArithmeticException if overflow occurs
   */
  public val absoluteValue: Centuries
    get() = Centuries(absExact(value))

  /**
   * Converts this duration to months. @throws ArithmeticException if overflow occurs
   */
  public val inMonths: Months
    get() = Months(value timesExact MONTHS_PER_CENTURY)

  /**
   * Converts this duration to months without checking for overflow.
   */
  internal val inMonthsUnchecked: Months
    get() = Months(value * MONTHS_PER_CENTURY)

  /**
   * Converts this duration to years. @throws ArithmeticException if overflow occurs
   */
  public val inYears: Years
    get() = Years(value timesExact YEARS_PER_CENTURY)

  /**
   * Converts this duration to years without checking for overflow.
   */
  internal val inYearsUnchecked: Years
    get() = Years(value * YEARS_PER_CENTURY)

  /**
   * Converts this duration to decades. @throws ArithmeticException if overflow occurs
   */
  public val inDecades: Decades
    get() = Decades(value timesExact DECADES_PER_CENTURY)

  /**
   * Converts this duration to decades without checking for overflow.
   */
  internal val inDecadesUnchecked: Decades
    get() = Decades(value * DECADES_PER_CENTURY)

  public constructor(`value`: Int) : this(value.toLong())

  /**
   * Checks if this duration is zero.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this == 0L.centuries"),
    level = DeprecationLevel.ERROR
  )
  public fun isZero(): Boolean = value == 0L

  /**
   * Checks if this duration is negative.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this < 0L.centuries"),
    level = DeprecationLevel.ERROR
  )
  public fun isNegative(): Boolean = value < 0L

  /**
   * Checks if this duration is positive.
   */
  @Deprecated(
    message = "Replace with direct comparison.",
    replaceWith = ReplaceWith("this > 0L.centuries"),
    level = DeprecationLevel.ERROR
  )
  public fun isPositive(): Boolean = value > 0L

  public override fun compareTo(other: Centuries): Int = value.compareTo(other.value)

  /**
   * Converts this duration to an ISO-8601 time interval representation.
   */
  public override fun toString(): String {
     return when (value) {
       0L -> "P0Y"
       Long.MIN_VALUE -> "-P9223372036854775808Y"
       else -> buildString {
         if (value < 0) { append('-') }
         append("P")
         append(value.absoluteValue timesExact 100)
         append('Y')
       }
     }
  }

  /**
   * Negates this duration. @throws ArithmeticException if overflow occurs
   */
  public operator fun unaryMinus(): Centuries = Centuries(value.negateExact())

  /**
   * Negates this duration without checking for overflow.
   */
  internal fun negateUnchecked(): Centuries = Centuries(-value)

  public operator fun plus(months: Months): Months = this.inMonths + months

  public operator fun minus(months: Months): Months = this.inMonths - months

  public operator fun plus(years: Years): Years = this.inYears + years

  public operator fun minus(years: Years): Years = this.inYears - years

  public operator fun plus(decades: Decades): Decades = this.inDecades + decades

  public operator fun minus(decades: Decades): Decades = this.inDecades - decades

  public operator fun plus(centuries: Centuries): Centuries = Centuries(value plusExact
      centuries.value)

  public operator fun minus(centuries: Centuries): Centuries = Centuries(value minusExact
      centuries.value)

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Int): Centuries = Centuries(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Int): Centuries {
     return if (scalar == -1) {
       -this
     } else {
       Centuries(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Int): Centuries = Centuries(value % scalar)

  /**
   * Multiplies this duration by a scalar value. @throws ArithmeticException if overflow occurs
   */
  public operator fun times(scalar: Long): Centuries = Centuries(value timesExact scalar)

  /**
   * Returns this duration divided by a scalar value. @throws ArithmeticException if overflow occurs
   * or the scalar is zero
   */
  public operator fun div(scalar: Long): Centuries {
     return if (scalar == -1L) {
       -this
     } else {
       Centuries(value / scalar)
     }
  }

  /**
   * Returns the remainder of this duration divided by a scalar value.
   */
  public operator fun rem(scalar: Long): Centuries = Centuries(value % scalar)

  /**
   * Converts this duration to an `Int` value. @throws ArithmeticException if overflow occurs
   */
  public fun toInt(): Int = value.toIntExact()

  /**
   * Converts this duration to an `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked(): Int = value.toInt()

  /**
   * Converts this duration to [IntCenturies]. @throws ArithmeticException if overflow occurs
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  public fun toIntCenturies(): Centuries = this

  /**
   * Converts this duration to [IntCenturies] without checking for overflow.
   */
  @Deprecated(
    message = "The 'Int' class no longer exists.",
    replaceWith = ReplaceWith("this"),
    level = DeprecationLevel.ERROR
  )
  @PublishedApi
  internal fun toIntCenturiesUnchecked(): Centuries = this

  /**
   * Converts this duration to a `Long` value.
   */
  public fun toLong(): Long = value

  /**
   * Converts this duration to a `Double` value.
   */
  public fun toDouble(): Double = value.toDouble()

  public companion object {
    /**
     * The smallest supported value.
     */
    public val MIN: Centuries = Centuries(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    public val MAX: Centuries = Centuries(Long.MAX_VALUE)
  }
}

/**
 * Converts this value to a duration of centuries.
 */
public val Int.centuries: Centuries
  get() = Centuries(this)

/**
 * Multiplies this value by a duration of centuries. @throws ArithmeticException if overflow occurs
 */
public operator fun Int.times(centuries: Centuries): Centuries = centuries * this

/**
 * Converts this value to a duration of centuries.
 */
public val Long.centuries: Centuries
  get() = Centuries(this)

/**
 * Multiplies this value by a duration of centuries. @throws ArithmeticException if overflow occurs
 */
public operator fun Long.times(centuries: Centuries): Centuries = centuries * this
