/*
 * Decompiled with CFR 0.152.
 */
package io.ipinfo.api.model;

import com.google.gson.annotations.SerializedName;
import io.ipinfo.api.context.Context;
import io.ipinfo.api.model.Prefix;
import java.util.List;

public class ASNResponse {
    private final String asn;
    private final String name;
    private final String country;
    private final String allocated;
    private final String registry;
    private final String domain;
    @SerializedName(value="num_ips")
    private final Integer numIps;
    private final String type;
    private final List<Prefix> prefixes;
    private final List<Prefix> prefixes6;
    private final List<String> peers;
    private final List<String> upstreams;
    private final List<String> downstreams;
    private transient Context context;

    public ASNResponse(String asn, String name, String country, String allocated, String registry, String domain, Integer numIps, String type, List<Prefix> prefixes, List<Prefix> prefixes6, List<String> peers, List<String> upstreams, List<String> downstreams) {
        this.asn = asn;
        this.name = name;
        this.country = country;
        this.allocated = allocated;
        this.registry = registry;
        this.domain = domain;
        this.numIps = numIps;
        this.type = type;
        this.prefixes = prefixes;
        this.prefixes6 = prefixes6;
        this.peers = peers;
        this.upstreams = upstreams;
        this.downstreams = downstreams;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getAsn() {
        return this.asn;
    }

    public String getName() {
        return this.name;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCountryCode() {
        return this.country;
    }

    public String getCountryName() {
        return this.context.getCountryName(this.getCountryCode());
    }

    public String getAllocated() {
        return this.allocated;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getDomain() {
        return this.domain;
    }

    public Integer getNumIps() {
        return this.numIps;
    }

    public String getType() {
        return this.type;
    }

    public List<Prefix> getPrefixes() {
        return this.prefixes;
    }

    public List<Prefix> getPrefixes6() {
        return this.prefixes6;
    }

    public List<String> getPeers() {
        return this.peers;
    }

    public List<String> getUpstreams() {
        return this.upstreams;
    }

    public List<String> getDownstreams() {
        return this.downstreams;
    }

    public String toString() {
        return "ASNResponse{asn='" + this.asn + "', name='" + this.name + "', country='" + this.country + "', allocated='" + this.allocated + "', registry='" + this.registry + "', domain='" + this.domain + "', numIps='" + this.numIps + "', type='" + this.type + "', prefixes=" + this.prefixes + ", prefixes6=" + this.prefixes6 + ", peers=" + this.peers + ", upstreams=" + this.upstreams + ", downstreams=" + this.downstreams + "}";
    }
}

