/*
 * Decompiled with CFR 0.152.
 */
package io.ipinfo.api.context;

import io.ipinfo.api.model.Continent;
import io.ipinfo.api.model.CountryCurrency;
import io.ipinfo.api.model.CountryFlag;
import java.util.List;
import java.util.Map;

public class Context {
    private final Map<String, String> countryMap;
    private final Map<String, CountryFlag> countriesFlags;
    private final Map<String, CountryCurrency> countriesCurrencies;
    private final Map<String, Continent> continents;
    private final List<String> euCountries;
    private static final String CountryFlagURL = "https://cdn.ipinfo.io/static/images/countries-flags/";

    public Context(Map<String, String> countryMap, List<String> euCountries, Map<String, CountryFlag> countriesFlags, Map<String, CountryCurrency> countriesCurrencies, Map<String, Continent> continents) {
        this.countryMap = countryMap;
        this.euCountries = euCountries;
        this.countriesFlags = countriesFlags;
        this.countriesCurrencies = countriesCurrencies;
        this.continents = continents;
    }

    public String getCountryName(String countryCode) {
        return this.countryMap.get(countryCode);
    }

    public CountryFlag getCountryFlag(String countryCode) {
        return this.countriesFlags.get(countryCode);
    }

    public String getCountryFlagURL(String countryCode) {
        return CountryFlagURL + countryCode + ".svg";
    }

    public CountryCurrency getCountryCurrency(String countryCode) {
        return this.countriesCurrencies.get(countryCode);
    }

    public Continent getContinent(String countryCode) {
        return this.continents.get(countryCode);
    }

    public boolean isEU(String countryCode) {
        return this.euCountries.contains(countryCode);
    }
}

