/*
 * Decompiled with CFR 0.152.
 */
package io.ipinfo.api.cache;

import io.ipinfo.api.cache.Cache;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.Map;

public class SimpleCache
implements Cache {
    private final Duration duration;
    private final Map<String, Payload> cache = new HashMap<String, Payload>();

    public SimpleCache(Duration duration) {
        this.duration = duration;
    }

    @Override
    public Object get(String key) {
        Payload payload = this.cache.get(key);
        if (payload == null || payload.hasExpired()) {
            return null;
        }
        return payload.data;
    }

    @Override
    public boolean set(String key, Object val) {
        this.cache.put(key, new Payload(val, this.duration));
        return true;
    }

    @Override
    public boolean clear() {
        this.cache.clear();
        return true;
    }

    private static class Payload {
        final Object data;
        final Instant creation;
        final Duration expiration;

        Payload(Object data, Duration duration) {
            this.data = data;
            this.creation = Instant.now();
            this.expiration = duration;
        }

        public boolean hasExpired() {
            long time = this.expiration.addTo(this.creation).getLong(ChronoField.INSTANT_SECONDS);
            long now = System.currentTimeMillis();
            return now <= time;
        }

        public Object getData() {
            return this.data;
        }
    }
}

