/*
 * Decompiled with CFR 0.152.
 */
package io.ipinfo.api;

import com.google.common.net.InetAddresses;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.ipinfo.api.cache.Cache;
import io.ipinfo.api.cache.SimpleCache;
import io.ipinfo.api.context.Context;
import io.ipinfo.api.errors.RateLimitedException;
import io.ipinfo.api.model.ASNResponse;
import io.ipinfo.api.model.Continent;
import io.ipinfo.api.model.CountryCurrency;
import io.ipinfo.api.model.CountryFlag;
import io.ipinfo.api.model.IPResponse;
import io.ipinfo.api.model.MapResponse;
import io.ipinfo.api.request.ASNRequest;
import io.ipinfo.api.request.IPRequest;
import io.ipinfo.api.request.MapRequest;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class IPinfo {
    private static final int batchMaxSize = 1000;
    private static final int batchReqTimeoutDefault = 5;
    private static final BatchReqOpts defaultBatchReqOpts = new BatchReqOpts.Builder().setBatchSize(1000).setTimeoutPerBatch(5).build();
    private static final Gson gson = new Gson();
    private final OkHttpClient client;
    private final Context context;
    private final String token;
    private final Cache cache;

    IPinfo(OkHttpClient client, Context context, String token, Cache cache) {
        this.client = client;
        this.context = context;
        this.token = token;
        this.cache = cache;
    }

    public static void main(String ... args) {
        System.out.println("This library is not meant to be run as a standalone jar.");
        System.exit(0);
    }

    public IPResponse lookupIP(String ip) throws RateLimitedException {
        IPResponse response = (IPResponse)this.cache.get(IPinfo.cacheKey(ip));
        if (response != null) {
            return response;
        }
        response = new IPRequest(this.client, this.token, ip).handle();
        response.setContext(this.context);
        this.cache.set(IPinfo.cacheKey(ip), response);
        return response;
    }

    public ASNResponse lookupASN(String asn) throws RateLimitedException {
        ASNResponse response = (ASNResponse)this.cache.get(IPinfo.cacheKey(asn));
        if (response != null) {
            return response;
        }
        response = new ASNRequest(this.client, this.token, asn).handle();
        response.setContext(this.context);
        this.cache.set(IPinfo.cacheKey(asn), response);
        return response;
    }

    public String getMap(List<String> ips) throws RateLimitedException {
        MapResponse response = new MapRequest(this.client, this.token, ips).handle();
        return response.getReportUrl();
    }

    public ConcurrentHashMap<String, Object> getBatch(List<String> urls) throws RateLimitedException {
        return this.getBatchGeneric(urls, defaultBatchReqOpts);
    }

    public ConcurrentHashMap<String, Object> getBatch(List<String> urls, BatchReqOpts opts) throws RateLimitedException {
        return this.getBatchGeneric(urls, opts);
    }

    public ConcurrentHashMap<String, IPResponse> getBatchIps(List<String> ips) throws RateLimitedException {
        return new ConcurrentHashMap<String, Object>(this.getBatchGeneric(ips, defaultBatchReqOpts));
    }

    public ConcurrentHashMap<String, IPResponse> getBatchIps(List<String> ips, BatchReqOpts opts) throws RateLimitedException {
        return new ConcurrentHashMap<String, Object>(this.getBatchGeneric(ips, opts));
    }

    public ConcurrentHashMap<String, ASNResponse> getBatchAsns(List<String> asns) throws RateLimitedException {
        return new ConcurrentHashMap<String, Object>(this.getBatchGeneric(asns, defaultBatchReqOpts));
    }

    public ConcurrentHashMap<String, ASNResponse> getBatchAsns(List<String> asns, BatchReqOpts opts) throws RateLimitedException {
        return new ConcurrentHashMap<String, Object>(this.getBatchGeneric(asns, opts));
    }

    private ConcurrentHashMap<String, Object> getBatchGeneric(List<String> urls, BatchReqOpts opts) throws RateLimitedException {
        List<String> lookupUrls;
        final ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>(urls.size());
        if (this.cache != null) {
            lookupUrls = new ArrayList<String>(urls.size() / 2);
            for (String url : urls) {
                Object val = this.cache.get(IPinfo.cacheKey(url));
                if (val != null) {
                    result.put(url, val);
                    continue;
                }
                lookupUrls.add(url);
            }
        } else {
            lookupUrls = urls;
        }
        if (lookupUrls.size() == 0) {
            return result;
        }
        int batchSize = opts.batchSize == 0 || opts.batchSize > 1000 ? 1000 : opts.batchSize;
        int timeoutPerBatch = opts.timeoutPerBatch == 0 ? 5 : opts.timeoutPerBatch;
        String postUrl = opts.filter ? "https://ipinfo.io/batch?filter=1" : "https://ipinfo.io/batch";
        final CountDownLatch latch = new CountDownLatch((int)Math.ceil((double)lookupUrls.size() / 1000.0));
        Request.Builder reqCommon = new Request.Builder().url(postUrl).addHeader("Content-Type", "application/json").addHeader("Authorization", Credentials.basic((String)this.token, (String)"")).addHeader("User-Agent", "IPinfoClient/Java/2.2.2");
        for (int i = 0; i < lookupUrls.size(); i += batchSize) {
            int end = i + batchSize;
            if (end > lookupUrls.size()) {
                end = lookupUrls.size();
            }
            List<String> urlsChunk = lookupUrls.subList(i, end);
            String urlListJson = gson.toJson(urlsChunk);
            RequestBody requestBody = RequestBody.create(null, (String)urlListJson);
            Request req = reqCommon.post(requestBody).build();
            OkHttpClient chunkClient = this.client.newBuilder().connectTimeout((long)timeoutPerBatch, TimeUnit.SECONDS).readTimeout((long)timeoutPerBatch, TimeUnit.SECONDS).build();
            chunkClient.newCall(req).enqueue(new Callback(){

                @ParametersAreNonnullByDefault
                public void onFailure(Call call, IOException e) {
                    latch.countDown();
                }

                @ParametersAreNonnullByDefault
                public void onResponse(Call call, Response response) throws IOException {
                    if (response.body() == null || response.code() == 429) {
                        return;
                    }
                    Type respType = new TypeToken<HashMap<String, Object>>(){}.getType();
                    HashMap localResult = (HashMap)gson.fromJson(response.body().string(), respType);
                    localResult.forEach(new BiConsumer<String, Object>(){

                        @Override
                        public void accept(String k, Object v) {
                            if (k.startsWith("AS")) {
                                String vStr = gson.toJson(v);
                                ASNResponse vCasted = (ASNResponse)gson.fromJson(vStr, ASNResponse.class);
                                vCasted.setContext(IPinfo.this.context);
                                result.put(k, vCasted);
                            } else if (InetAddresses.isInetAddress((String)k)) {
                                String vStr = gson.toJson(v);
                                IPResponse vCasted = (IPResponse)gson.fromJson(vStr, IPResponse.class);
                                vCasted.setContext(IPinfo.this.context);
                                result.put(k, vCasted);
                            } else {
                                result.put(k, v);
                            }
                        }
                    });
                    latch.countDown();
                }
            });
        }
        try {
            if (opts.timeoutTotal == 0) {
                latch.await();
            } else {
                boolean success = latch.await(opts.timeoutTotal, TimeUnit.SECONDS);
                if (!success) {
                    if (result.size() == 0) {
                        return null;
                    }
                    return result;
                }
            }
        }
        catch (InterruptedException e) {
            if (result.size() == 0) {
                return null;
            }
            return result;
        }
        if (this.cache != null) {
            for (String url : lookupUrls) {
                Object v = result.get(url);
                if (v == null) continue;
                this.cache.set(IPinfo.cacheKey(url), v);
            }
        }
        return result;
    }

    public static String cacheKey(String k) {
        return k + ":1";
    }

    public static class BatchReqOpts {
        public final int batchSize;
        public final int timeoutPerBatch;
        public final int timeoutTotal;
        public final boolean filter;

        public BatchReqOpts(int batchSize, int timeoutPerBatch, int timeoutTotal, boolean filter) {
            this.batchSize = batchSize;
            this.timeoutPerBatch = timeoutPerBatch;
            this.timeoutTotal = timeoutTotal;
            this.filter = filter;
        }

        public static class Builder {
            private int batchSize = 1000;
            private int timeoutPerBatch = 5;
            private int timeoutTotal = 0;
            private boolean filter = false;

            public Builder setBatchSize(int batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder setTimeoutPerBatch(int timeoutPerBatch) {
                this.timeoutPerBatch = timeoutPerBatch;
                return this;
            }

            public Builder setTimeoutTotal(int timeoutTotal) {
                this.timeoutTotal = timeoutTotal;
                return this;
            }

            public Builder setFilter(boolean filter) {
                this.filter = filter;
                return this;
            }

            public BatchReqOpts build() {
                return new BatchReqOpts(this.batchSize, this.timeoutPerBatch, this.timeoutTotal, this.filter);
            }
        }
    }

    public static class Builder {
        private File countryFile = new File(this.getClass().getClassLoader().getResource("en_US.json").getFile());
        private File euCountryFile = new File(this.getClass().getClassLoader().getResource("eu.json").getFile());
        private File countryFlagFile = new File(this.getClass().getClassLoader().getResource("flags.json").getFile());
        private File countryCurrencyFile = new File(this.getClass().getClassLoader().getResource("currency.json").getFile());
        private File continentFile = new File(this.getClass().getClassLoader().getResource("continent.json").getFile());
        private OkHttpClient client = new OkHttpClient.Builder().build();
        private String token = "";
        private Cache cache = new SimpleCache(Duration.ofDays(1L));

        public Builder setClient(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setCountryFile(File file) {
            this.countryFile = file;
            return this;
        }

        public Builder setEUCountryFile(File file) {
            this.euCountryFile = file;
            return this;
        }

        public Builder setCountryFlagFile(File file) {
            this.countryFlagFile = file;
            return this;
        }

        public Builder setCountryCurrencyFile(File file) {
            this.countryCurrencyFile = file;
            return this;
        }

        public Builder setContinentFile(File file) {
            this.continentFile = file;
            return this;
        }

        public Builder setCache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public IPinfo build() {
            List<String> euList;
            Map<String, Continent> continents;
            Map<String, CountryCurrency> countriesCurrencies;
            Map<String, CountryFlag> countriesFlags;
            Map<String, String> map;
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Type euCountriesType = new TypeToken<List<String>>(){}.getType();
            Type countriesFlagsType = new TypeToken<Map<String, CountryFlag>>(){}.getType();
            Type countriesCurrencyType = new TypeToken<Map<String, CountryCurrency>>(){}.getType();
            Type continentType = new TypeToken<Map<String, Continent>>(){}.getType();
            Gson gson = new Gson();
            try {
                map = Collections.unmodifiableMap((Map)gson.fromJson((Reader)new FileReader(this.countryFile), type));
                countriesFlags = Collections.unmodifiableMap((Map)gson.fromJson((Reader)new FileReader(this.countryFlagFile), countriesFlagsType));
                countriesCurrencies = Collections.unmodifiableMap((Map)gson.fromJson((Reader)new FileReader(this.countryCurrencyFile), countriesCurrencyType));
                continents = Collections.unmodifiableMap((Map)gson.fromJson((Reader)new FileReader(this.continentFile), continentType));
                euList = Collections.unmodifiableList((List)gson.fromJson((Reader)new FileReader(this.euCountryFile), euCountriesType));
            }
            catch (Exception e) {
                map = Collections.unmodifiableMap(new HashMap());
                countriesFlags = Collections.unmodifiableMap(new HashMap());
                countriesCurrencies = Collections.unmodifiableMap(new HashMap());
                continents = Collections.unmodifiableMap(new HashMap());
                euList = Collections.unmodifiableList(new ArrayList());
            }
            return new IPinfo(this.client, new Context(map, euList, countriesFlags, countriesCurrencies, continents), this.token, this.cache);
        }
    }
}

