/*
 * Decompiled with CFR 0.152.
 */
package io.ipinfo.api.request;

import io.ipinfo.api.errors.RateLimitedException;
import io.ipinfo.api.model.IPResponse;
import io.ipinfo.api.request.BaseRequest;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class IPRequest
extends BaseRequest<IPResponse> {
    private static final String URL_FORMAT = "https://ipinfo.io/%s";
    private final String ip;

    public IPRequest(OkHttpClient client, String token, String ip) {
        super(client, token);
        this.ip = ip;
    }

    @Override
    public IPResponse handle() throws RateLimitedException {
        String url = String.format(URL_FORMAT, this.ip);
        Request.Builder request = new Request.Builder().url(url).get();
        try (Response response = this.handleRequest(request);){
            if (response == null || response.body() == null) {
                IPResponse iPResponse = null;
                return iPResponse;
            }
            IPResponse iPResponse = (IPResponse)gson.fromJson(response.body().string(), IPResponse.class);
            return iPResponse;
        }
    }
}

