/*
 * Decompiled with CFR 0.152.
 */
package io.ipinfo.api.model;

import io.ipinfo.api.context.Context;
import io.ipinfo.api.model.ASN;
import io.ipinfo.api.model.Abuse;
import io.ipinfo.api.model.Carrier;
import io.ipinfo.api.model.Company;
import io.ipinfo.api.model.Domains;
import io.ipinfo.api.model.Privacy;

public class IPResponse {
    private final String ip;
    private final String hostname;
    private final boolean anycast;
    private final String city;
    private final String region;
    private final String country;
    private final String loc;
    private final String org;
    private final String postal;
    private final String timezone;
    private final ASN asn;
    private final Company company;
    private final Carrier carrier;
    private final Privacy privacy;
    private final Abuse abuse;
    private final Domains domains;
    private transient Context context;

    public IPResponse(String ip, String hostname, boolean anycast, String city, String region, String country, String loc, String org, String postal, String timezone, ASN asn, Company company, Carrier carrier, Privacy privacy, Abuse abuse, Domains domains) {
        this.ip = ip;
        this.hostname = hostname;
        this.anycast = anycast;
        this.city = city;
        this.region = region;
        this.country = country;
        this.loc = loc;
        this.postal = postal;
        this.timezone = timezone;
        this.org = org;
        this.asn = asn;
        this.company = company;
        this.carrier = carrier;
        this.privacy = privacy;
        this.abuse = abuse;
        this.domains = domains;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getIp() {
        return this.ip;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean getAnycast() {
        return this.anycast;
    }

    public String getCity() {
        return this.city;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCountryCode() {
        return this.country;
    }

    public String getCountryName() {
        return this.context.getCountryName(this.getCountryCode());
    }

    public String getLocation() {
        return this.loc;
    }

    public String getLatitude() {
        try {
            return this.loc.split(",")[0];
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getLongitude() {
        try {
            return this.loc.split(",")[1];
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getOrg() {
        return this.org;
    }

    public String getPostal() {
        return this.postal;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public ASN getAsn() {
        return this.asn;
    }

    public Company getCompany() {
        return this.company;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public Abuse getAbuse() {
        return this.abuse;
    }

    public Domains getDomains() {
        return this.domains;
    }

    public String toString() {
        return "IPResponse{ip='" + this.ip + '\'' + ", hostname='" + this.hostname + '\'' + ", anycast=" + this.anycast + ", city='" + this.city + '\'' + ", region='" + this.region + '\'' + ", country='" + this.country + '\'' + ", loc='" + this.loc + '\'' + ", org='" + this.org + '\'' + ", postal='" + this.postal + '\'' + ", timezone='" + this.timezone + '\'' + ", asn=" + this.asn + ", company=" + this.company + ", carrier=" + this.carrier + ", privacy=" + this.privacy + ", abuse=" + this.abuse + ", domains=" + this.domains + '}';
    }
}

