/*
 * Decompiled with CFR 0.152.
 */
package iotchain.core.model;

import iotchain.core.codec.Encoder;
import iotchain.core.crypto.Hash;
import iotchain.core.crypto.Signer;
import iotchain.core.model.RawTransaction;
import iotchain.core.model.protocol.Hashable;
import iotchain.core.model.protocol.Rlpable;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.web3j.crypto.ECDSASignature;
import org.web3j.crypto.Keys;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class SignedTransaction
extends RawTransaction
implements Rlpable,
Hashable {
    private BigInteger v;
    private BigInteger r;
    private BigInteger s;

    public SignedTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String receivingAddress, BigInteger value, String payload, BigInteger v, BigInteger r, BigInteger s) {
        super(nonce, gasPrice, gasLimit, receivingAddress, value, payload);
        this.v = v;
        this.r = r;
        this.s = s;
    }

    public SignedTransaction(RawTransaction rawTx, BigInteger v, BigInteger r, BigInteger s) {
        this(rawTx.getNonce(), rawTx.getGasPrice(), rawTx.getGasLimit(), rawTx.getReceivingAddress(), rawTx.getValue(), rawTx.getPayload(), v, r, s);
    }

    public BigInteger getV() {
        return this.v;
    }

    public void setV(BigInteger v) {
        this.v = v;
    }

    public BigInteger getR() {
        return this.r;
    }

    public void setR(BigInteger r) {
        this.r = r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public void setS(BigInteger s) {
        this.s = s;
    }

    @Override
    public List<RlpType> asRlpValues() {
        List<RlpType> result = this.rlpValuesToSign();
        result.add((RlpType)RlpString.create((BigInteger)this.getV()));
        result.add((RlpType)RlpString.create((BigInteger)this.getR()));
        result.add((RlpType)RlpString.create((BigInteger)this.getS()));
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignedTransaction that = (SignedTransaction)o;
        return Objects.equals(this.nonce, that.nonce) && Objects.equals(this.gasPrice, that.gasPrice) && Objects.equals(this.gasLimit, that.gasLimit) && Objects.equals(Numeric.cleanHexPrefix((String)this.receivingAddress), Numeric.cleanHexPrefix((String)that.receivingAddress)) && Objects.equals(this.value, that.value) && Objects.equals(Numeric.cleanHexPrefix((String)this.payload), Numeric.cleanHexPrefix((String)that.payload)) && Objects.equals(this.v, that.v) && Objects.equals(this.r, that.r) && Objects.equals(this.s, that.s);
    }

    public Long chainId() {
        Long recoveryId = this.v.longValue();
        if (recoveryId < 27L) {
            return null;
        }
        if (recoveryId % 2L == 0L) {
            return (recoveryId - 28L) / 2L;
        }
        return (recoveryId - 27L) / 2L;
    }

    public String getSender() {
        Long chainId = this.chainId();
        byte[] bytesToSign = this.bytesToSign(chainId);
        ECDSASignature ecdsaSig = new ECDSASignature(this.r, this.s);
        Integer recId = this.getPointSign();
        BigInteger publicKey = Signer.recover(recId, ecdsaSig, bytesToSign);
        return Keys.getAddress((BigInteger)publicKey);
    }

    private Integer getPointSign() {
        Long chainId = this.chainId();
        BigInteger recoverId = this.getV();
        Integer diff = recoverId.subtract(BigInteger.valueOf(chainId * 2L)).intValue();
        if (diff == 27 || diff == 28) {
            return diff;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.nonce, this.gasPrice, this.gasLimit, this.receivingAddress, this.value, this.payload, this.v, this.r, this.s);
    }

    @Override
    public String hash() {
        byte[] rlp = Encoder.encode(this);
        return Numeric.toHexString((byte[])Hash.sha3(rlp));
    }
}

