/*
 * Decompiled with CFR 0.152.
 */
package iotchain.core.crypto;

import iotchain.core.model.RawTransaction;
import iotchain.core.model.SignedTransaction;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import org.web3j.crypto.ECDSASignature;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public class Signer {
    public static final Integer NEGATIVE_POINT_SIGN = 27;
    public static final Integer POSITIVE_POINT_SIGN = 28;
    public static final Integer NEW_NEGATIVE_POINT_SIGN = 27;
    public static final Integer NEW_POSITIVE_POINT_SIGN = 28;
    public static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
    static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    static final BigInteger HALF_CURVE_ORDER = CURVE_PARAMS.getN().shiftRight(1);

    public static BigInteger recover(int recId, ECDSASignature sig, byte[] message) {
        ECPoint R;
        BigInteger n = CURVE.getN();
        BigInteger prime = SecP256K1Curve.q;
        if (sig.r.compareTo(prime) < 0 && (R = Signer.constructPoint(sig.r, recId)).multiply(n).isInfinity()) {
            BigInteger e = new BigInteger(1, message);
            BigInteger rInv = sig.r.modInverse(n);
            BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
            BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
            BigInteger srInv = rInv.multiply(sig.s).mod(n);
            ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)CURVE.getG(), (BigInteger)eInvrInv, (ECPoint)R, (BigInteger)srInv);
            byte[] qBytes = q.getEncoded(false);
            return new BigInteger(1, Arrays.copyOfRange(qBytes, 1, qBytes.length));
        }
        return null;
    }

    public static String getSender(SignedTransaction tx) {
        return tx.getSender();
    }

    public static SignedTransaction signTx(RawTransaction tx, String privateKey, Long chainId) {
        SignedTransaction stx = new SignedTransaction(tx.getNonce(), tx.getGasPrice(), tx.getGasLimit(), tx.getReceivingAddress(), tx.getValue(), tx.getPayload(), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO);
        ECKeyPair keyPair = ECKeyPair.create((BigInteger)Numeric.toBigInt((String)privateKey));
        Sign.SignatureData sd = Sign.signMessage((byte[])stx.bytesToSign(chainId), (ECKeyPair)keyPair, (boolean)false);
        BigInteger recoveryId = Signer.getRecoveryId(chainId, Numeric.toBigInt((byte[])sd.getV()));
        stx.setV(recoveryId);
        stx.setR(Numeric.toBigInt((byte[])sd.getR()));
        stx.setS(Numeric.toBigInt((byte[])sd.getS()));
        return stx;
    }

    private static BigInteger getRecoveryId(Long chainId, BigInteger pointSign) {
        if (pointSign.compareTo(BigInteger.valueOf(NEGATIVE_POINT_SIGN.intValue())) == 0) {
            return BigInteger.valueOf(chainId * 2L + (long)NEW_NEGATIVE_POINT_SIGN.intValue());
        }
        if (pointSign.compareTo(BigInteger.valueOf(POSITIVE_POINT_SIGN.intValue())) == 0) {
            return BigInteger.valueOf(chainId * 2L + (long)NEW_POSITIVE_POINT_SIGN.intValue());
        }
        return null;
    }

    private static ECPoint constructPoint(BigInteger xBN, Integer recId) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(CURVE.getCurve()));
        compEnc[0] = (byte)(recId == 28 ? 3 : 2);
        return CURVE.getCurve().decodePoint(compEnc);
    }
}

