/*
 * Decompiled with CFR 0.152.
 */
package iotchain.core.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import iotchain.core.api.ApiResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class Api {
    private static OkHttpClient client = new OkHttpClient.Builder().retryOnConnectionFailure(false).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
    private String url;

    public Api(String url) {
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    protected <T> List<T> call2(String path, Map data, Class<T> clazz) throws IOException {
        TypeReference type = new TypeReference<ApiResponse<List<T>>>(new Type[]{clazz}){};
        ApiResponse apiResponse = (ApiResponse)this.callInner(path, data, type);
        return (List)apiResponse.getResult();
    }

    protected <T> T call(String path, Map data, Class<T> clazz) throws IOException {
        TypeReference type = new TypeReference<ApiResponse<T>>(new Type[]{clazz}){};
        ApiResponse apiResponse = (ApiResponse)this.callInner(path, data, type);
        return apiResponse.getResult();
    }

    private <T> T callInner(String path, Map data, TypeReference<T> type) throws IOException {
        String json = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNonStringValueAsString});
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
        Request request = new Request.Builder().url(this.url + "/" + path).post(body).build();
        try (Response response = client.newCall(request).execute();){
            Object apiResponse;
            String resp = response.body().string();
            Object object = apiResponse = JSON.parseObject((String)resp, type, (Feature[])new Feature[0]);
            return (T)object;
        }
    }
}

