/*
 * Decompiled with CFR 0.152.
 */
package iotchain.core.model;

import iotchain.core.codec.Encoder;
import iotchain.core.crypto.Hash;
import iotchain.core.model.protocol.Hashable;
import iotchain.core.model.protocol.Rlpable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class BlockHeader
implements Rlpable,
Hashable {
    private String parentHash;
    private String beneficiary;
    private String stateRoot;
    private String transactionsRoot;
    private String receiptsRoot;
    private String logsBloom;
    private BigInteger difficulty;
    private BigInteger number;
    private BigInteger gasLimit;
    private BigInteger gasUsed;
    private Long unixTimestamp;
    private String extra;

    public BlockHeader(String parentHash, String beneficiary, String stateRoot, String transactionsRoot, String receiptsRoot, String logsBloom, BigInteger difficulty, BigInteger number, BigInteger gasLimit, BigInteger gasUsed, Long unixTimestamp, String extra) {
        this.parentHash = parentHash;
        this.beneficiary = beneficiary;
        this.stateRoot = stateRoot;
        this.transactionsRoot = transactionsRoot;
        this.receiptsRoot = receiptsRoot;
        this.logsBloom = logsBloom;
        this.difficulty = difficulty;
        this.number = number;
        this.gasLimit = gasLimit;
        this.gasUsed = gasUsed;
        this.unixTimestamp = unixTimestamp;
        this.extra = extra;
    }

    public String getParentHash() {
        return this.parentHash;
    }

    public String getBeneficiary() {
        return this.beneficiary;
    }

    public String getStateRoot() {
        return this.stateRoot;
    }

    public String getTransactionsRoot() {
        return this.transactionsRoot;
    }

    public String getReceiptsRoot() {
        return this.receiptsRoot;
    }

    public String getLogsBloom() {
        return this.logsBloom;
    }

    public BigInteger getDifficulty() {
        return this.difficulty;
    }

    public BigInteger getNumber() {
        return this.number;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    public Long getUnixTimestamp() {
        return this.unixTimestamp;
    }

    public String getExtra() {
        return this.extra;
    }

    @Override
    public List<RlpType> asRlpValues() {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getParentHash())));
        result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getBeneficiary())));
        result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getStateRoot())));
        result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTransactionsRoot())));
        result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getReceiptsRoot())));
        result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getLogsBloom())));
        result.add((RlpType)RlpString.create((BigInteger)this.getDifficulty()));
        result.add((RlpType)RlpString.create((BigInteger)this.getNumber()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasUsed()));
        result.add((RlpType)RlpString.create((long)this.getUnixTimestamp()));
        byte[] extraBytes = Numeric.hexStringToByteArray((String)this.getExtra());
        RlpList extraDecoded = RlpDecoder.decode((byte[])extraBytes);
        result.addAll(extraDecoded.getValues());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockHeader that = (BlockHeader)o;
        return Objects.equals(Numeric.cleanHexPrefix((String)this.parentHash), Numeric.cleanHexPrefix((String)that.parentHash)) && Objects.equals(Numeric.cleanHexPrefix((String)this.beneficiary), Numeric.cleanHexPrefix((String)that.beneficiary)) && Objects.equals(Numeric.cleanHexPrefix((String)this.stateRoot), Numeric.cleanHexPrefix((String)that.stateRoot)) && Objects.equals(Numeric.cleanHexPrefix((String)this.transactionsRoot), Numeric.cleanHexPrefix((String)that.transactionsRoot)) && Objects.equals(Numeric.cleanHexPrefix((String)this.receiptsRoot), Numeric.cleanHexPrefix((String)that.receiptsRoot)) && Objects.equals(Numeric.cleanHexPrefix((String)this.logsBloom), Numeric.cleanHexPrefix((String)that.logsBloom)) && Objects.equals(this.difficulty, that.difficulty) && Objects.equals(this.number, that.number) && Objects.equals(this.gasLimit, that.gasLimit) && Objects.equals(this.gasUsed, that.gasUsed) && Objects.equals(this.unixTimestamp, that.unixTimestamp) && Objects.equals(Numeric.cleanHexPrefix((String)this.extra), Numeric.cleanHexPrefix((String)that.extra));
    }

    public int hashCode() {
        return Objects.hash(this.parentHash, this.beneficiary, this.stateRoot, this.transactionsRoot, this.receiptsRoot, this.logsBloom, this.difficulty, this.number, this.gasLimit, this.gasUsed, this.unixTimestamp, this.extra);
    }

    @Override
    public String hash() {
        byte[] rlp = Encoder.encode(this);
        return Numeric.toHexString((byte[])Hash.sha3(rlp));
    }
}

