/*
 * Decompiled with CFR 0.152.
 */
package iotchain.core.api;

import iotchain.core.api.Api;
import iotchain.core.model.Receipt;
import iotchain.core.model.SignedTransaction;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;

public class TransactionApi
extends Api {
    private static String PATH = "transaction";

    public TransactionApi(String url) {
        super(url);
    }

    public SignedTransaction getTx(String hash) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hash", hash);
        return this.call(PATH + "/getTx", map, SignedTransaction.class);
    }

    public SignedTransaction getPendingTx(String hash) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hash", hash);
        return this.call(PATH + "/getPendingTx", map, SignedTransaction.class);
    }

    public Receipt getReceipt(String hash) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hash", hash);
        return this.call(PATH + "/getReceipt", map, Receipt.class);
    }

    public SignedTransaction getTxByBlockHashAndIndex(String hash, Integer index) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hash", hash);
        map.put("index", index + "");
        return this.call(PATH + "/getTxByBlockHashAndIndex", map, SignedTransaction.class);
    }

    public SignedTransaction getTxByBlockTagAndIndex(BigInteger tag, Integer index) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tag", tag == null ? "latest" : tag + "");
        map.put("index", index + "");
        return this.call(PATH + "/getTxByBlockTagAndIndex", map, SignedTransaction.class);
    }

    public String sendTx(SignedTransaction transaction) throws IOException {
        HashMap<String, SignedTransaction> map = new HashMap<String, SignedTransaction>();
        map.put("stx", transaction);
        return this.call(PATH + "/sendTx", map, String.class);
    }
}

