package io.ionic.liveupdates.data.model

import android.util.Base64
import kotlinx.serialization.Serializable
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.json.Json

/**
 * A class representing the manifest associated with diff downloads and validating secure Live Updates payloads.
 *
 * @property signatures an optional list of signatures in the manifest to validate files
 * @property payload the encoded payload of the manifest
 */
@Serializable
data class Manifest(val signatures: List<Signature>? = null, val payload: String) {
    /**
     * The decoded payload containing a list of [PayloadFile]
     */
    val decodedPayload: List<PayloadFile> by lazy {
        val decodedPayload = String(Base64.decode(payload, Base64.DEFAULT))
        Json.decodeFromString(ListSerializer(PayloadFile.serializer()), decodedPayload)
    }
}