package io.ionic.liveupdates.data.model

import kotlinx.serialization.Serializable

/**
 * A class representing
 *
 * @property id the ID of the app snapshot
 * @property buildId the build ID for the app snapshot
 * @property binaryVersion the binary version the snapshot is associated with
 * @property lastUsed the timestamp the snapshot was last used
 */
@Serializable
data class Snapshot(
    val id: String,
    val buildId: String,
    var binaryVersion: String,
    var lastUsed: Long
)