package io.ionic.liveupdates

import android.util.Log

internal object Logger {
    const val LOG_TAG = "LiveUpdates"

    var isLoggingEnabled = true

    fun verbose(message: String) {
        verbose(LOG_TAG, message)
    }

    fun verbose(tag: String, message: String) {
        if (!isLoggingEnabled) {
            return
        }

        Log.v(tag, message)
    }

    fun debug(message: String) {
        debug(LOG_TAG, message)
    }

    fun debug(tag: String, message: String) {
        if (!isLoggingEnabled) {
            return
        }

        Log.d(tag, message)
    }

    fun info(message: String) {
        info(LOG_TAG, message)
    }

    fun info(tag: String, message: String) {
        if (!isLoggingEnabled) {
            return
        }

        Log.i(tag, message)
    }

    fun warn(message: String) {
        warn(LOG_TAG, message)
    }

    fun warn(tag: String, message: String) {
        if (!isLoggingEnabled) {
            return
        }

        Log.w(tag, message)
    }

    fun error(message: String) {
        error(LOG_TAG, message)
    }

    fun error(tag: String, message: String) {
        if (!isLoggingEnabled) {
            return
        }

        Log.e(tag, message)
    }

    fun error(message: String, e: Throwable) {
        error(LOG_TAG, message, e)
    }

    fun error(tag: String, message: String, e: Throwable) {
        if (!isLoggingEnabled) {
            return
        }

        Log.e(tag, message, e)
    }

}