package io.ionic.liveupdates.data.model.network.response

import kotlinx.serialization.Serializable

/**
 * A class representing data returned from Appflow describing a potential available update.
 *
 * @property url the download URL or manifest URL if there is an available update
 * @property available if there is an app update available
 * @property snapshot the ID of the available snapshot if available
 * @property partial if the available update is a partial update
 * @property build the ID of the available build if available
 * @property compatible if the available update is compatible with the current native app
 * @property incompatibleUpdateAvailable if there is an update available but it is incompatible with the current native app
 */
@Serializable
data class Data(
    val url: String?,
    val available: Boolean,
    val snapshot: String?,
    val partial: Boolean,
    val build: String?,
    val compatible: Boolean,
    val incompatibleUpdateAvailable: Boolean
)