package io.ionic.liveupdates.data.model

import kotlinx.serialization.Serializable

/**
 * A class representing a file within a Live Update payload.
 *
 * @property href the path of the file
 * @property size the size of the file
 * @property integrity the MD5 hash of the file
 */
@Serializable
data class PayloadFile(val href: String, val size: Long, val integrity: String)