package io.ionic.liveupdates.data.model

import kotlinx.serialization.Serializable

/**
 * A class that represents a device to provide information to the server.
 *
 * @property binary_version the application binary version
 * @property device_id the ID of the device
 */
@Serializable
data class Device(val binary_version: String, val device_id: String) {
    /**
     * The native device platform
     */
    val platform = "android"

    /**
     * The version of the platform operating system
     */
    val platform_version = android.os.Build.VERSION.SDK_INT.toString()

    /**
     * The ID of the current snapshot of an app loaded from a Live Update
     */
    var snapshot: String? = null

    /**
     * The ID of the current build of an app loaded from a Live Update
     */
    var build: String? = null
}