package io.ionic.liveupdates.network

import java.io.File

/**
 * A callback used to access the results of the Live Update Extract process.
 *
 * Example usage (kotlin):
 * ```kotlin
 * // Async extract call
 * LiveUpdateManager.extractUpdate("appId", zipFile, object : ExtractCallback {
 *     override fun onComplete(result: File?) {
 *         println(response?.path)
 *     }
 * })
 * ```
 *
 * Example usage (Java):
 * ```java
 * // Async extract call
 * LiveUpdateManager.extractUpdate(getContext(), zipFile, extractedFile -> {
 *     // Do something with file
 * });
 * ```
 */
interface ExtractCallback {
    /**
     * Called when the extract process is complete.
     *
     * @param file the path of the extracted archive
     */
    fun onComplete(file: File?)
}