package io.ionic.liveupdates.network

import io.ionic.liveupdates.data.model.network.response.DownloadResponse

/**
 * A callback used to access the results of the Live Update Download process.
 *
 * Example usage (kotlin):
 * ```kotlin
 * // Async download call
 * LiveUpdateManager.downloadUpdate(applicationContext, "appId", "snapshotId", object : DownloadCallback {
 *     override fun onComplete(result: DownloadResponse?) {
 *         // Do something with result
 *     }
 * })
 * ```
 *
 * Example usage (Java):
 * ```java
 * // Async download call
 * LiveUpdateManager.downloadUpdate(getContext(), "appId", "snapshotId", downloadResponse -> {
 *     // Do something with response
 * });
 * ```
 */
interface DownloadCallback {
    /**
     * Called when the Download process is complete.
     *
     * @param result the result information from the Download process
     */
    fun onComplete(result: DownloadResponse?)
}