package io.ionic.liveupdates.network

import io.ionic.liveupdates.data.model.network.response.CheckResponse

/**
 * A callback used to access the results of the Live Update update check process.
 *
 * Example usage (kotlin):
 * ```kotlin
 * // Async check call
 * LiveUpdateManager.checkForUpdate(context, "appId", object : CheckCallback {
 *     override fun onComplete(result: CheckResponse?) {
 *         // Do something with the result
 *     }
 * })
 * ```
 *
 * Example usage (Java):
 * ```java
 * // Async check call
 * LiveUpdateManager.checkForUpdate(context, "appId", checkResponse -> {
 *     // Do something with response
 * });
 * ```
 */
interface CheckCallback {
    /**
     * Called when the update check process is complete.
     *
     * @param result the result information from the update check process
     */
    fun onComplete(result: CheckResponse?)
}