package io.ionic.liveupdates.data.model.network.response

import kotlinx.serialization.Serializable

/**
 * A class representing error data returned from a request.
 *
 * @property link a link for the error
 * @property message information about the error
 * @property type the error type
 * @property details a list of more details about the error
 * @property event_id an event ID related to the error
 */
@Serializable
data class Error(
    val link: String?,
    val message: String,
    val type: String,
    val details: List<Details>?,
    val event_id: String?
)

