package io.ionic.liveupdates.data.model.network.request

import io.ionic.liveupdates.data.model.Device
import kotlinx.serialization.Serializable

/**
 * A class representing the request body for a check update request.
 *
 * @property device information about the device making the request
 * @property app_id the ID for the application
 * @property channel_name the name of the channel to check for updates in
 * @property is_portals whether the application is using Ionic Portals
 */
@Serializable
data class CheckRequest(val device: Device, val app_id: String, val channel_name: String, val is_portals: Boolean) {
    /**
     * The version of the Live Updates plugin
     */
    var plugin_version = "5.4.7"

    /**
     * If the request should result in a manifest or zip download link if an update is available
     */
    var manifest = false
}

