package io.ionic.liveupdates.data.model

import io.ionic.liveupdates.LiveUpdate

/**
 * A class representing a successful sync attempt for an app.
 *
 * @property liveUpdate
 * @property snapshot
 * @property source the source the application loaded from
 * @property latestAppDirectoryChanged whether the app directory changed or not
 */
class SyncResult(
    val liveUpdate: LiveUpdate,
    val snapshot: Snapshot?,
    val source: Source,
    val latestAppDirectoryChanged: Boolean
)