package io.ionic.liveupdates.data.model

import io.ionic.liveupdates.LiveUpdate

/**
 * Represents a failed request during the Live Updates process and information about the failure.
 *
 * @property liveUpdate the [LiveUpdate] information for the failed request
 * @property failStep the step the Live Update process failure occurred
 * @property failMsg a message to accompany the failure to explain what happened
 */
class FailResult(
    val liveUpdate: LiveUpdate,
    val failStep: FailStep,
    val failMsg: String? = null
)

/**
 * A state representing the step in the Live Update process where a failure occurred.
 */
enum class FailStep {
    /**
     * Check for update step.
     */
    CHECK,

    /**
     * Download step.
     */
    DOWNLOAD,

    /**
     * Unpack step.
     */
    UNPACK,

    /**
     * Verification step (secure Live Updates).
     */
    VERIFY,

    /**
     * Update step.
     */
    UPDATE,

    /**
     * Canceled.
     */
    CANCEL
}