package io.ionic.liveupdates.data.model

import android.util.Base64
import kotlinx.serialization.Serializable
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.json.Json

@Serializable
data class PayloadFile(val href: String, val size: Long, val integrity: String)

@Serializable
data class Signature(val protected: String, val signature: String)

@Serializable
data class SecureManifest(
    val signatures: List<Signature>,
    val payload: String) {
    val decodedPayload: List<PayloadFile> by lazy {
        val decodedPayload = String(Base64.decode(payload, Base64.DEFAULT))
        Json.decodeFromString(ListSerializer(PayloadFile.serializer()), decodedPayload)
    }
}