package io.ionic.liveupdates

class LiveUpdate(val appId: String, val channelName: String = "production", val usesSecureLiveUpdates: Boolean = false) {
    var availableUpdate: AvailableUpdateState? = null
        internal set

    var appState: AppState = AppState.UNCHECKED
        internal set

    constructor(appId: String, channelName: String = "production") : this(appId, channelName, false)
    constructor(appId: String) : this(appId, "production", false)
}

enum class AvailableUpdateState {
    AVAILABLE, PENDING, READY
}

enum class AppState {
    UNCHECKED, CHECKING, CHECKED, AVAILABLE, DOWNLOADING, DOWNLOADED, UNPACKING, UNPACKED, VERIFYING, VERIFIED, UPDATING, UPDATED, CANCELED, FAILED
}