package io.ionic.liveupdates.data.model

import kotlinx.serialization.Serializable

@Serializable
data class App(val id: String) {
    val channels: MutableList<Channel> = mutableListOf()
    val snapshots: MutableList<String> = mutableListOf()

    var lastSync: Long = -1

    fun addChannel(channel: Channel) {
        if (!channels.contains(channel)) {
            channels.add(channel)
        }
    }

    fun getChannel(id: String): Channel? {
        val currentChannel = channels.filter { channel -> channel.id == id }
        if (currentChannel.isNotEmpty()) {
            return currentChannel[0]
        }

        return null
    }

    fun getCurrentSnapshot(channelId: String): String? {
        val currentChannel = getChannel(channelId)
        if (currentChannel != null) {
            if (snapshots.contains(currentChannel.currentSnapshot)) {
                return currentChannel.currentSnapshot
            }
        }

        return null
    }

    fun removeSnapshot(snapshotId: String) {
        for (channel in channels) {
            if (channel.currentSnapshot == snapshotId) {
                channel.currentSnapshot = ""
            }
        }

        snapshots.remove(snapshotId)
    }
}