/*
 * Decompiled with CFR 0.152.
 */
package sdjwtwrapper;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import sdjwtwrapper.FfiConverter;
import sdjwtwrapper.NoCopySource;
import sdjwtwrapper.RustBuffer;
import sdjwtwrapper.Sdjwtwrapper_jvmKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lsdjwtwrapper/FfiConverterString;", "Lsdjwtwrapper/FfiConverter;", "", "Lsdjwtwrapper/RustBuffer;", "()V", "allocationSize", "", "value", "lift", "lower", "read", "buf", "Lsdjwtwrapper/NoCopySource;", "write", "", "Lokio/Buffer;", "sd-jwt-kmp"})
public final class FfiConverterString
implements FfiConverter<String, RustBuffer> {
    @NotNull
    public static final FfiConverterString INSTANCE = new FfiConverterString();

    private FfiConverterString() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String lift(@NotNull RustBuffer value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        try {
            byte[] byteArr = Sdjwtwrapper_jvmKt.asSource(value).readByteArray(Sdjwtwrapper_jvmKt.getDataSize(value));
            String string = StringsKt.decodeToString((byte[])byteArr);
            return string;
        }
        finally {
            Sdjwtwrapper_jvmKt.free(value);
        }
    }

    @Override
    @NotNull
    public String read(@NotNull NoCopySource buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int len = buf.readInt();
        byte[] byteArr = buf.readByteArray(len);
        return StringsKt.decodeToString((byte[])byteArr);
    }

    @Override
    @NotNull
    public RustBuffer lower(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Buffer buffer = new Buffer().write(StringsKt.encodeToByteArray((String)value));
        return Sdjwtwrapper_jvmKt.allocRustBuffer(buffer);
    }

    @Override
    public int allocationSize(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int sizeForLength = 4;
        int sizeForString = value.length() * 3;
        return sizeForLength + sizeForString;
    }

    @Override
    public void write(@NotNull String value, @NotNull Buffer buf) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        byte[] byteArr = StringsKt.encodeToByteArray((String)value);
        buf.writeInt(byteArr.length);
        buf.write(byteArr);
    }

    @Override
    @NotNull
    public RustBuffer lowerIntoRustBuffer(@NotNull String value) {
        return FfiConverter.DefaultImpls.lowerIntoRustBuffer(this, value);
    }

    @Override
    @NotNull
    public String liftFromRustBuffer(@NotNull RustBuffer rbuf) {
        return FfiConverter.DefaultImpls.liftFromRustBuffer(this, rbuf);
    }
}

