/*
 * Decompiled with CFR 0.152.
 */
package sdjwtwrapper;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import sdjwtwrapper.FfiConverterRustBuffer;
import sdjwtwrapper.FfiConverterString;
import sdjwtwrapper.NoCopySource;
import sdjwtwrapper.RustBuffer;
import sdjwtwrapper.SdjwtException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lsdjwtwrapper/FfiConverterTypeSDJWTError;", "Lsdjwtwrapper/FfiConverterRustBuffer;", "Lsdjwtwrapper/SdjwtException;", "()V", "allocationSize", "", "value", "read", "buf", "Lsdjwtwrapper/NoCopySource;", "write", "", "Lokio/Buffer;", "sd-jwt-kmp"})
public final class FfiConverterTypeSDJWTError
implements FfiConverterRustBuffer<SdjwtException> {
    @NotNull
    public static final FfiConverterTypeSDJWTError INSTANCE = new FfiConverterTypeSDJWTError();

    private FfiConverterTypeSDJWTError() {
    }

    @Override
    @NotNull
    public SdjwtException read(@NotNull NoCopySource buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return switch (buf.readInt()) {
            case 1 -> new SdjwtException.ConversionException(FfiConverterString.INSTANCE.read(buf));
            case 2 -> new SdjwtException.DeserializationException(FfiConverterString.INSTANCE.read(buf));
            case 3 -> new SdjwtException.DataFieldMismatch(FfiConverterString.INSTANCE.read(buf));
            case 4 -> new SdjwtException.DuplicateDigestException(FfiConverterString.INSTANCE.read(buf));
            case 5 -> new SdjwtException.DuplicateKeyException(FfiConverterString.INSTANCE.read(buf));
            case 6 -> new SdjwtException.InvalidDisclosure(FfiConverterString.INSTANCE.read(buf));
            case 7 -> new SdjwtException.InvalidArrayDisclosureObject(FfiConverterString.INSTANCE.read(buf));
            case 8 -> new SdjwtException.InvalidPath(FfiConverterString.INSTANCE.read(buf));
            case 9 -> new SdjwtException.IndexOutOfBounds(FfiConverterString.INSTANCE.read(buf));
            case 10 -> new SdjwtException.InvalidState(FfiConverterString.INSTANCE.read(buf));
            case 11 -> new SdjwtException.InvalidInput(FfiConverterString.INSTANCE.read(buf));
            case 12 -> new SdjwtException.KeyNotFound(FfiConverterString.INSTANCE.read(buf));
            case 13 -> new SdjwtException.Unspecified(FfiConverterString.INSTANCE.read(buf));
            default -> throw new RuntimeException("invalid error enum value, something is very wrong!!");
        };
    }

    @Override
    public int allocationSize(@NotNull SdjwtException value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return 4;
    }

    @Override
    public void write(@NotNull SdjwtException value, @NotNull Buffer buf) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        SdjwtException sdjwtException = value;
        if (sdjwtException instanceof SdjwtException.ConversionException) {
            buf.writeInt(1);
        } else if (sdjwtException instanceof SdjwtException.DeserializationException) {
            buf.writeInt(2);
        } else if (sdjwtException instanceof SdjwtException.DataFieldMismatch) {
            buf.writeInt(3);
        } else if (sdjwtException instanceof SdjwtException.DuplicateDigestException) {
            buf.writeInt(4);
        } else if (sdjwtException instanceof SdjwtException.DuplicateKeyException) {
            buf.writeInt(5);
        } else if (sdjwtException instanceof SdjwtException.InvalidDisclosure) {
            buf.writeInt(6);
        } else if (sdjwtException instanceof SdjwtException.InvalidArrayDisclosureObject) {
            buf.writeInt(7);
        } else if (sdjwtException instanceof SdjwtException.InvalidPath) {
            buf.writeInt(8);
        } else if (sdjwtException instanceof SdjwtException.IndexOutOfBounds) {
            buf.writeInt(9);
        } else if (sdjwtException instanceof SdjwtException.InvalidState) {
            buf.writeInt(10);
        } else if (sdjwtException instanceof SdjwtException.InvalidInput) {
            buf.writeInt(11);
        } else if (sdjwtException instanceof SdjwtException.KeyNotFound) {
            buf.writeInt(12);
        } else if (sdjwtException instanceof SdjwtException.Unspecified) {
            buf.writeInt(13);
        }
    }

    @Override
    @NotNull
    public SdjwtException lift(@NotNull RustBuffer value) {
        return FfiConverterRustBuffer.DefaultImpls.lift(this, value);
    }

    @Override
    @NotNull
    public RustBuffer lower(@NotNull SdjwtException value) {
        return FfiConverterRustBuffer.DefaultImpls.lower(this, value);
    }

    @Override
    @NotNull
    public RustBuffer lowerIntoRustBuffer(@NotNull SdjwtException value) {
        return FfiConverterRustBuffer.DefaultImpls.lowerIntoRustBuffer(this, value);
    }

    @Override
    @NotNull
    public SdjwtException liftFromRustBuffer(@NotNull RustBuffer rbuf) {
        return FfiConverterRustBuffer.DefaultImpls.liftFromRustBuffer(this, rbuf);
    }
}

