// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package sdjwtwrapper

import com.sun.jna.Pointer
import okio.Buffer

// Suppressing the diagnostics caused by https://youtrack.jetbrains.com/issue/KT-37316
@Suppress("ACTUAL_WITHOUT_EXPECT")
internal actual typealias Pointer = com.sun.jna.Pointer

internal actual fun kotlin.Long.toPointer() = com.sun.jna.Pointer(this)

internal actual fun Pointer.toLong(): kotlin.Long = com.sun.jna.Pointer.nativeValue(this)

// Suppressing the diagnostics caused by https://youtrack.jetbrains.com/issue/KT-37316
@Suppress("ACTUAL_WITHOUT_EXPECT")
internal actual typealias UBytePointer = com.sun.jna.Pointer

internal actual fun UBytePointer.asSource(len: kotlin.Long): NoCopySource = object : NoCopySource {
    val buffer = getByteBuffer(0, len).also {
        it.order(java.nio.ByteOrder.BIG_ENDIAN)
    }

    override fun exhausted(): kotlin.Boolean = !buffer.hasRemaining()

    override fun readByte(): kotlin.Byte = buffer.get()

    override fun readInt(): kotlin.Int = buffer.getInt()

    override fun readLong(): kotlin.Long = buffer.getLong()

    override fun readShort(): kotlin.Short = buffer.getShort()

    override fun readByteArray(): ByteArray {
        val remaining = buffer.remaining()
        return readByteArray(remaining.toLong())
    }

    override fun readByteArray(len: kotlin.Long): ByteArray {
        val startIndex = buffer.position().toLong()
        val indexAfterLast = (startIndex + len).toInt()
        val byteArray = getByteArray(startIndex, len.toInt())
        buffer.position(indexAfterLast)
        return byteArray
    }
}

@com.sun.jna.Structure.FieldOrder("capacity", "len", "data")
internal open class RustBufferStructure : com.sun.jna.Structure() {
    @JvmField var capacity: kotlin.Int = 0
    @JvmField var len: kotlin.Int = 0
    @JvmField var data: com.sun.jna.Pointer? = null
}

internal actual open class RustBuffer : RustBufferStructure(), com.sun.jna.Structure.ByValue

internal actual class RustBufferByReference : com.sun.jna.ptr.ByReference(16) {
    fun setValueInternal(value: RustBuffer) {
        pointer.setInt(0, value.capacity)
        pointer.setInt(4, value.len)
        pointer.setPointer(8, value.data)
    }
}

internal actual fun RustBuffer.asSource(): NoCopySource = requireNotNull(data).asSource(len.toLong())

internal actual val RustBuffer.dataSize: kotlin.Int
    get() = len

internal actual fun RustBuffer.free() =
    rustCall { status: sdjwtwrapper.RustCallStatus ->
        UniFFILib.ffi_sdjwtwrapper_rustbuffer_free(this, status)
    }

internal actual fun allocRustBuffer(buffer: Buffer): RustBuffer =
    rustCall { status: sdjwtwrapper.RustCallStatus ->
        val size = buffer.size
        var readPosition = 0L
        UniFFILib.ffi_sdjwtwrapper_rustbuffer_alloc(size.toInt(), status).also { rustBuffer: RustBuffer ->
            val data = rustBuffer.data
                ?: throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
            rustBuffer.writeField("len", size.toInt())
            // Loop until the buffer is completed read, okio reads max 8192 bytes
            while (readPosition < size) {
                readPosition += buffer.read(data.getByteBuffer(readPosition, size - readPosition))
            }
        }
    }

internal actual fun RustBufferByReference.setValue(value: RustBuffer) = setValueInternal(value)

internal actual fun emptyRustBuffer(): RustBuffer = RustBuffer()

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@com.sun.jna.Structure.FieldOrder("len", "data")
internal actual open class ForeignBytes : com.sun.jna.Structure() {
    @JvmField var len: kotlin.Int = 0
    @JvmField var data: com.sun.jna.Pointer? = null
}
@com.sun.jna.Structure.FieldOrder("code", "error_buf")
internal actual open class RustCallStatus : com.sun.jna.Structure() {
    @JvmField var code: kotlin.Byte = 0
    @JvmField var error_buf: RustBuffer = RustBuffer()
}

internal actual val RustCallStatus.statusCode: kotlin.Byte
    get() = code
internal actual val RustCallStatus.errorBuffer: RustBuffer
    get() = error_buf

internal actual fun <T> withRustCallStatus(block: (RustCallStatus) -> T): T {
    val rustCallStatus = RustCallStatus()
    return block(rustCallStatus)
}

// TODO remove suppress when https://youtrack.jetbrains.com/issue/KT-29819/New-rules-for-expect-actual-declarations-in-MPP is solved
@Suppress("NO_ACTUAL_FOR_EXPECT")
internal actual open class RustCallStatusByValue : RustCallStatus(), com.sun.jna.Structure.ByValue

internal actual class UniFfiHandleMap<T : Any> {
    private val map = java.util.concurrent.ConcurrentHashMap<kotlin.ULong, T>()

    // Use AtomicInteger for our counter, since we may be on a 32-bit system.  4 billion possible
    // values seems like enough. If somehow we generate 4 billion handles, then this will wrap
    // around back to zero and we can assume the first handle generated will have been dropped by
    // then.
    private val counter = java.util.concurrent.atomic.AtomicInteger(0)

    actual val size: kotlin.Int
        get() = map.size

    actual fun insert(obj: T): kotlin.ULong {
        val handle = counter.getAndAdd(1).toULong()
        map.put(handle, obj)
        return handle
    }

    actual fun get(handle: kotlin.ULong): T? {
        return map.get(handle)
    }

    actual fun remove(handle: kotlin.ULong): T? {
        return map.remove(handle)
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations.
@Synchronized
private fun findLibraryName(): kotlin.String {
    val componentName = "sdjwtwrapper"
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "sdjwtwrapper"
}

actual internal object UniFFILib : com.sun.jna.Library {
    init {
        com.sun.jna.Native.register(UniFFILib::class.java, findLibraryName())
        
    }

    @JvmName("uniffi_sdjwtwrapper_fn_free_encodingkeyvalue")
    actual external fun uniffi_sdjwtwrapper_fn_free_encodingkeyvalue(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_base64_secret")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_base64_secret(`b64`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ec_der")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ec_der(`ecDer`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ec_pem")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ec_pem(`ecPem`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ed_der")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ed_der(`edDer`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ed_pem")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ed_pem(`edPem`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_rsa_der")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_rsa_der(`rsaDer`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_rsa_pem")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_rsa_pem(`rsaPem`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_secret")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_secret(`secret`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_free_jwkvalue")
    actual external fun uniffi_sdjwtwrapper_fn_free_jwkvalue(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_jwkvalue_new")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_jwkvalue_new(`jwkJson`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_method_jwkvalue_get_json")
    actual external fun uniffi_sdjwtwrapper_fn_method_jwkvalue_get_json(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer

    @JvmName("uniffi_sdjwtwrapper_fn_free_sdjwtholderwrapper")
    actual external fun uniffi_sdjwtwrapper_fn_free_sdjwtholderwrapper(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_sdjwtholderwrapper_new")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_sdjwtholderwrapper_new(`sdJwtWithDisclosures`: RustBuffer,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_method_sdjwtholderwrapper_create_presentation")
    actual external fun uniffi_sdjwtwrapper_fn_method_sdjwtholderwrapper_create_presentation(`ptr`: Pointer,`claimsToDiscloseJson`: RustBuffer,`nonce`: RustBuffer,`aud`: RustBuffer,`holderKey`: RustBuffer,`signAlg`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer

    @JvmName("uniffi_sdjwtwrapper_fn_free_sdjwtissuerwrapper")
    actual external fun uniffi_sdjwtwrapper_fn_free_sdjwtissuerwrapper(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_sdjwtissuerwrapper_new")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_sdjwtissuerwrapper_new(`issuerKey`: Pointer,`signAlg`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_all_level")
    actual external fun uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_all_level(`ptr`: Pointer,`userClaims`: RustBuffer,`holderKey`: RustBuffer,`addDecoyClaims`: Byte,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer

    @JvmName("uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_custom")
    actual external fun uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_custom(`ptr`: Pointer,`userClaims`: RustBuffer,`jsonPaths`: RustBuffer,`holderKey`: RustBuffer,`addDecoyClaims`: Byte,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer

    @JvmName("uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_no_sd_claims")
    actual external fun uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_no_sd_claims(`ptr`: Pointer,`userClaims`: RustBuffer,`holderKey`: RustBuffer,`addDecoyClaims`: Byte,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer

    @JvmName("uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_top_level")
    actual external fun uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_top_level(`ptr`: Pointer,`userClaims`: RustBuffer,`holderKey`: RustBuffer,`addDecoyClaims`: Byte,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer

    @JvmName("uniffi_sdjwtwrapper_fn_free_sdjwtverifierwrapper")
    actual external fun uniffi_sdjwtwrapper_fn_free_sdjwtverifierwrapper(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit

    @JvmName("uniffi_sdjwtwrapper_fn_constructor_sdjwtverifierwrapper_new")
    actual external fun uniffi_sdjwtwrapper_fn_constructor_sdjwtverifierwrapper_new(`sdJwtPresentation`: RustBuffer,`publicKey`: RustBuffer,`expectedAud`: RustBuffer,`expectedNonce`: RustBuffer,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Pointer

    @JvmName("uniffi_sdjwtwrapper_fn_method_sdjwtverifierwrapper_get_verified_claims")
    actual external fun uniffi_sdjwtwrapper_fn_method_sdjwtverifierwrapper_get_verified_claims(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer

    @JvmName("uniffi_sdjwtwrapper_fn_method_sdjwtverifierwrapper_verify")
    actual external fun uniffi_sdjwtwrapper_fn_method_sdjwtverifierwrapper_verify(`ptr`: Pointer,`userClaimsJson`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Byte

    @JvmName("ffi_sdjwtwrapper_rustbuffer_alloc")
    actual external fun ffi_sdjwtwrapper_rustbuffer_alloc(`size`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer

    @JvmName("ffi_sdjwtwrapper_rustbuffer_from_bytes")
    actual external fun ffi_sdjwtwrapper_rustbuffer_from_bytes(`bytes`: ForeignBytes,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer

    @JvmName("ffi_sdjwtwrapper_rustbuffer_free")
    actual external fun ffi_sdjwtwrapper_rustbuffer_free(`buf`: RustBuffer,_uniffi_out_err: RustCallStatus, 
    ): Unit

    @JvmName("ffi_sdjwtwrapper_rustbuffer_reserve")
    actual external fun ffi_sdjwtwrapper_rustbuffer_reserve(`buf`: RustBuffer,`additional`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer

    @JvmName("uniffi_sdjwtwrapper_checksum_method_jwkvalue_get_json")
    actual external fun uniffi_sdjwtwrapper_checksum_method_jwkvalue_get_json(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_method_sdjwtholderwrapper_create_presentation")
    actual external fun uniffi_sdjwtwrapper_checksum_method_sdjwtholderwrapper_create_presentation(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_all_level")
    actual external fun uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_all_level(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_custom")
    actual external fun uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_custom(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_no_sd_claims")
    actual external fun uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_no_sd_claims(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_top_level")
    actual external fun uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_top_level(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_method_sdjwtverifierwrapper_get_verified_claims")
    actual external fun uniffi_sdjwtwrapper_checksum_method_sdjwtverifierwrapper_get_verified_claims(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_method_sdjwtverifierwrapper_verify")
    actual external fun uniffi_sdjwtwrapper_checksum_method_sdjwtverifierwrapper_verify(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_base64_secret")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_base64_secret(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ec_der")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ec_der(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ec_pem")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ec_pem(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ed_der")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ed_der(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ed_pem")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ed_pem(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_rsa_der")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_rsa_der(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_rsa_pem")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_rsa_pem(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_secret")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_secret(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_jwkvalue_new")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_jwkvalue_new(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_sdjwtholderwrapper_new")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_sdjwtholderwrapper_new(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_sdjwtissuerwrapper_new")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_sdjwtissuerwrapper_new(
    ): UShort

    @JvmName("uniffi_sdjwtwrapper_checksum_constructor_sdjwtverifierwrapper_new")
    actual external fun uniffi_sdjwtwrapper_checksum_constructor_sdjwtverifierwrapper_new(
    ): UShort

    @JvmName("ffi_sdjwtwrapper_uniffi_contract_version")
    actual external fun ffi_sdjwtwrapper_uniffi_contract_version(
    ): UInt

    
}

// Async support

// Public interface members begin here.




























