// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package sdjwtwrapper

import okio.Buffer
import kotlinx.atomicfu.*

// TODO remove suppress when https://youtrack.jetbrains.com/issue/KT-29819/New-rules-for-expect-actual-declarations-in-MPP is solved
@Suppress("NO_ACTUAL_FOR_EXPECT")
internal expect class Pointer

internal expect fun kotlin.Long.toPointer(): Pointer

internal expect fun Pointer.toLong(): kotlin.Long

// TODO remove suppress when https://youtrack.jetbrains.com/issue/KT-29819/New-rules-for-expect-actual-declarations-in-MPP is solved
@Suppress("NO_ACTUAL_FOR_EXPECT")
internal expect class UBytePointer

internal expect fun UBytePointer.asSource(len: kotlin.Long): NoCopySource

// TODO remove suppress when https://youtrack.jetbrains.com/issue/KT-29819/New-rules-for-expect-actual-declarations-in-MPP is solved
@Suppress("NO_ACTUAL_FOR_EXPECT")
internal expect class RustBuffer

// TODO remove suppress when https://youtrack.jetbrains.com/issue/KT-29819/New-rules-for-expect-actual-declarations-in-MPP is solved
@Suppress("NO_ACTUAL_FOR_EXPECT")
internal expect class RustBufferByReference

internal expect fun RustBuffer.asSource(): NoCopySource

internal expect val RustBuffer.dataSize: kotlin.Int

internal expect fun RustBuffer.free()

internal expect fun allocRustBuffer(buffer: Buffer): RustBuffer

internal expect fun RustBufferByReference.setValue(value: RustBuffer)

internal expect fun emptyRustBuffer(): RustBuffer

internal interface NoCopySource {
    fun exhausted(): kotlin.Boolean
    fun readByte(): kotlin.Byte
    fun readInt(): kotlin.Int
    fun readLong(): kotlin.Long
    fun readShort(): kotlin.Short
    fun readByteArray(): ByteArray
    fun readByteArray(len: kotlin.Long): ByteArray
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

// TODO remove suppress when https://youtrack.jetbrains.com/issue/KT-29819/New-rules-for-expect-actual-declarations-in-MPP is solved
@Suppress("NO_ACTUAL_FOR_EXPECT")
internal expect class ForeignBytes
// The FfiConverter interface handles converter types to and from the FFI
//
// All implementing objects should be public to support external types.  When a
// type is external we need to import it's FfiConverter.
internal interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `NoCopySource`
    fun read(buf: NoCopySource): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): Int

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: Buffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer {
        val buffer = Buffer().apply { write(value, buffer) }
        return allocRustBuffer(buffer)
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer): KotlinType {
        val byteBuf = rbuf.asSource()
        try {
            val item = read(byteBuf)
            if (!byteBuf.exhausted()) {
                throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
            }
            return item
        } finally {
            rbuf.free()
        }
    }
}

// FfiConverter that uses `RustBuffer` as the FfiType
internal interface FfiConverterRustBuffer<KotlinType> : FfiConverter<KotlinType, RustBuffer> {
    override fun lift(value: RustBuffer) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.
// Error runtime.
// TODO remove suppress when https://youtrack.jetbrains.com/issue/KT-29819/New-rules-for-expect-actual-declarations-in-MPP is solved
@Suppress("NO_ACTUAL_FOR_EXPECT")
internal expect class RustCallStatus
internal expect val RustCallStatus.statusCode: kotlin.Byte
internal expect val RustCallStatus.errorBuffer: RustBuffer

internal expect fun <T> withRustCallStatus(block: (RustCallStatus) -> T): T

// TODO remove suppress when https://youtrack.jetbrains.com/issue/KT-29819/New-rules-for-expect-actual-declarations-in-MPP is solved
@Suppress("NO_ACTUAL_FOR_EXPECT")
internal expect class RustCallStatusByValue

private const val RUST_CALL_STATUS_SUCCESS: kotlin.Byte = 0
private const val RUST_CALL_STATUS_ERROR: kotlin.Byte = 1
private const val RUST_CALL_STATUS_PANIC: kotlin.Byte = 2

internal fun RustCallStatus.isSuccess(): kotlin.Boolean {
    return statusCode == RUST_CALL_STATUS_SUCCESS
}

internal fun RustCallStatus.isError(): kotlin.Boolean {
    return statusCode == RUST_CALL_STATUS_ERROR
}

internal fun RustCallStatus.isPanic(): kotlin.Boolean {
    return statusCode == RUST_CALL_STATUS_PANIC
}

class InternalException(message: kotlin.String) : Exception(message)

// Each top-level error class has a companion object that can lift the error from the call status's rust buffer
internal interface CallStatusErrorHandler<E> {
    fun lift(errorBuffer: RustBuffer): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
internal inline fun <U, E : Exception> rustCallWithError(
    errorHandler: CallStatusErrorHandler<E>,
    crossinline callback: (RustCallStatus) -> U,
): U =
    withRustCallStatus { status: RustCallStatus ->
        val return_value = callback(status)
        checkCallStatus(errorHandler, status)
        return_value
    }

// Check RustCallStatus and throw an error if the call wasn't successful
internal fun <E : Exception> checkCallStatus(errorHandler: CallStatusErrorHandler<E>, status: RustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.errorBuffer)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.errorBuffer.dataSize > 0) {
            // TODO avoid additional copy
            throw InternalException(FfiConverterString.lift(status.errorBuffer))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

// CallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
internal object NullCallStatusErrorHandler : CallStatusErrorHandler<InternalException> {
    override fun lift(errorBuffer: RustBuffer): InternalException {
        errorBuffer.free()
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
internal inline fun <U> rustCall(crossinline callback: (RustCallStatus) -> U): U {
    return rustCallWithError(NullCallStatusErrorHandler, callback);
}

// Map handles to objects
//
// This is used when the Rust code expects an opaque pointer to represent some foreign object.
// Normally we would pass a pointer to the object, but JNA doesn't support getting a pointer from an
// object reference , nor does it support leaking a reference to Rust.
//
// Instead, this class maps ULong values to objects so that we can pass a pointer-sized type to
// Rust when it needs an opaque pointer.
//
// TODO: refactor callbacks to use this class
internal expect class UniFfiHandleMap<T : Any>() {

    val size: kotlin.Int

    fun insert(obj: T): kotlin.ULong

    fun get(handle: kotlin.ULong): T?

    fun remove(handle: kotlin.ULong): T?
}

// Contains loading, initialization code,
// and the FFI Function declarations.
internal expect object UniFFILib {
    fun uniffi_sdjwtwrapper_fn_free_encodingkeyvalue(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, ): Unit
    fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_base64_secret(`b64`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ec_der(`ecDer`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ec_pem(`ecPem`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ed_der(`edDer`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ed_pem(`edPem`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_rsa_der(`rsaDer`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_rsa_pem(`rsaPem`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_secret(`secret`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_free_jwkvalue(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, ): Unit
    fun uniffi_sdjwtwrapper_fn_constructor_jwkvalue_new(`jwkJson`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_method_jwkvalue_get_json(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, ): RustBuffer
    fun uniffi_sdjwtwrapper_fn_free_sdjwtholderwrapper(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, ): Unit
    fun uniffi_sdjwtwrapper_fn_constructor_sdjwtholderwrapper_new(`sdJwtWithDisclosures`: RustBuffer,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_method_sdjwtholderwrapper_create_presentation(`ptr`: Pointer,`claimsToDiscloseJson`: RustBuffer,`nonce`: RustBuffer,`aud`: RustBuffer,`holderKey`: RustBuffer,`signAlg`: RustBuffer,_uniffi_out_err: RustCallStatus, ): RustBuffer
    fun uniffi_sdjwtwrapper_fn_free_sdjwtissuerwrapper(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, ): Unit
    fun uniffi_sdjwtwrapper_fn_constructor_sdjwtissuerwrapper_new(`issuerKey`: Pointer,`signAlg`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_all_level(`ptr`: Pointer,`userClaims`: RustBuffer,`holderKey`: RustBuffer,`addDecoyClaims`: Byte,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, ): RustBuffer
    fun uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_custom(`ptr`: Pointer,`userClaims`: RustBuffer,`jsonPaths`: RustBuffer,`holderKey`: RustBuffer,`addDecoyClaims`: Byte,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, ): RustBuffer
    fun uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_no_sd_claims(`ptr`: Pointer,`userClaims`: RustBuffer,`holderKey`: RustBuffer,`addDecoyClaims`: Byte,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, ): RustBuffer
    fun uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_top_level(`ptr`: Pointer,`userClaims`: RustBuffer,`holderKey`: RustBuffer,`addDecoyClaims`: Byte,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, ): RustBuffer
    fun uniffi_sdjwtwrapper_fn_free_sdjwtverifierwrapper(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, ): Unit
    fun uniffi_sdjwtwrapper_fn_constructor_sdjwtverifierwrapper_new(`sdJwtPresentation`: RustBuffer,`publicKey`: RustBuffer,`expectedAud`: RustBuffer,`expectedNonce`: RustBuffer,`serializationFormat`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Pointer
    fun uniffi_sdjwtwrapper_fn_method_sdjwtverifierwrapper_get_verified_claims(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, ): RustBuffer
    fun uniffi_sdjwtwrapper_fn_method_sdjwtverifierwrapper_verify(`ptr`: Pointer,`userClaimsJson`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Byte
    fun ffi_sdjwtwrapper_rustbuffer_alloc(`size`: Int,_uniffi_out_err: RustCallStatus, ): RustBuffer
    fun ffi_sdjwtwrapper_rustbuffer_from_bytes(`bytes`: ForeignBytes,_uniffi_out_err: RustCallStatus, ): RustBuffer
    fun ffi_sdjwtwrapper_rustbuffer_free(`buf`: RustBuffer,_uniffi_out_err: RustCallStatus, ): Unit
    fun ffi_sdjwtwrapper_rustbuffer_reserve(`buf`: RustBuffer,`additional`: Int,_uniffi_out_err: RustCallStatus, ): RustBuffer
    fun uniffi_sdjwtwrapper_checksum_method_jwkvalue_get_json(): UShort
    fun uniffi_sdjwtwrapper_checksum_method_sdjwtholderwrapper_create_presentation(): UShort
    fun uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_all_level(): UShort
    fun uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_custom(): UShort
    fun uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_no_sd_claims(): UShort
    fun uniffi_sdjwtwrapper_checksum_method_sdjwtissuerwrapper_issue_sd_jwt_top_level(): UShort
    fun uniffi_sdjwtwrapper_checksum_method_sdjwtverifierwrapper_get_verified_claims(): UShort
    fun uniffi_sdjwtwrapper_checksum_method_sdjwtverifierwrapper_verify(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_base64_secret(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ec_der(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ec_pem(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ed_der(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_ed_pem(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_rsa_der(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_rsa_pem(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_encodingkeyvalue_from_secret(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_jwkvalue_new(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_sdjwtholderwrapper_new(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_sdjwtissuerwrapper_new(): UShort
    fun uniffi_sdjwtwrapper_checksum_constructor_sdjwtverifierwrapper_new(): UShort
    fun ffi_sdjwtwrapper_uniffi_contract_version(): UInt
    
}

// Async support

// Public interface members begin here.


internal object FfiConverterBoolean : FfiConverter<kotlin.Boolean, kotlin.Byte> {
    override fun lift(value: kotlin.Byte): kotlin.Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: NoCopySource): kotlin.Boolean {
        return lift(buf.readByte())
    }

    override fun lower(value: kotlin.Boolean): kotlin.Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: kotlin.Boolean) = 1

    override fun write(value: kotlin.Boolean, buf: Buffer) {
        buf.writeByte(lower(value).toInt())
    }
}

internal object FfiConverterString : FfiConverter<kotlin.String, RustBuffer> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer): kotlin.String {
        try {
            val byteArr = value.asSource().readByteArray(value.dataSize.toLong())
            return byteArr.decodeToString()
        } finally {
            value.free()
        }
    }

    override fun read(buf: NoCopySource): kotlin.String {
        val len = buf.readInt()
        val byteArr = buf.readByteArray(len.toLong())
        return byteArr.decodeToString()
    }

    override fun lower(value: kotlin.String): RustBuffer {
        val buffer = Buffer().write(value.encodeToByteArray())
        return allocRustBuffer(buffer)
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: kotlin.String): kotlin.Int {
        val sizeForLength = 4
        val sizeForString = value.length * 3
        return sizeForLength + sizeForString
    }

    override fun write(value: kotlin.String, buf: Buffer) {
        val byteArr = value.encodeToByteArray()
        buf.writeInt(byteArr.size)
        buf.write(byteArr)
    }
}




// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()

    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (_: Throwable) {
            // swallow
        }
    }

// The base class for all UniFFI Object types.
//
// This class provides core operations for working with the Rust `Arc<T>` pointer to
// the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// the Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each `FFIObject` instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an `FFIObject` is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an `FFIObject` instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so will
//     leak the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each `FFIObject` an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// In the future we may be able to replace some of this with automatic finalization logic, such as using
// the new "Cleaner" functionaility in Java 9. The above scheme has been designed to work even if `destroy` is
// invoked by garbage-collection machinery rather than by calling code (which by the way, it's apparently also
// possible for the JVM to finalize an object while there is an in-flight call to one of its methods [1],
// so there would still be some complexity here).
//
// Sigh...all of this for want of a robust finalization mechanism.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//
abstract class FFIObject internal constructor(
    internal val pointer: Pointer
) : Disposable {

    private val wasDestroyed: kotlinx.atomicfu.AtomicBoolean = atomic(false)
    private val callCounter: kotlinx.atomicfu.AtomicLong = atomic(1L)

    open protected fun freeRustArcPtr() {
        // To be overridden in subclasses.
    }

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(expect = false, update = true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                this.freeRustArcPtr()
            }
        }
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.value
            if (c == 0L) {
                throw IllegalStateException("${this::class.simpleName} object has already been destroyed")
            }
            if (c == kotlin.Long.MAX_VALUE) {
                throw IllegalStateException("${this::class.simpleName} call counter would overflow")
            }
        } while (!this.callCounter.compareAndSet(expect = c, update = c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
                try {
            return block(this.pointer)
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                this.freeRustArcPtr()
            }
        }
    }
}

public interface EncodingKeyValueInterface {
    
    companion object
}

class EncodingKeyValue internal constructor(
    pointer: Pointer
) : FFIObject(pointer), EncodingKeyValueInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall { status: RustCallStatus ->
            UniFFILib.uniffi_sdjwtwrapper_fn_free_encodingkeyvalue(this.pointer, status)
        }
    }

    

    companion object {
        fun `fromBase64Secret`(`b64`: kotlin.String): EncodingKeyValue =
            EncodingKeyValue(
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_base64_secret(FfiConverterString.lower(`b64`),_status)
})
        fun `fromEcDer`(`ecDer`: kotlin.String): EncodingKeyValue =
            EncodingKeyValue(
    rustCall { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ec_der(FfiConverterString.lower(`ecDer`),_status)
})
        fun `fromEcPem`(`ecPem`: kotlin.String): EncodingKeyValue =
            EncodingKeyValue(
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ec_pem(FfiConverterString.lower(`ecPem`),_status)
})
        fun `fromEdDer`(`edDer`: kotlin.String): EncodingKeyValue =
            EncodingKeyValue(
    rustCall { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ed_der(FfiConverterString.lower(`edDer`),_status)
})
        fun `fromEdPem`(`edPem`: kotlin.String): EncodingKeyValue =
            EncodingKeyValue(
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_ed_pem(FfiConverterString.lower(`edPem`),_status)
})
        fun `fromRsaDer`(`rsaDer`: kotlin.String): EncodingKeyValue =
            EncodingKeyValue(
    rustCall { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_rsa_der(FfiConverterString.lower(`rsaDer`),_status)
})
        fun `fromRsaPem`(`rsaPem`: kotlin.String): EncodingKeyValue =
            EncodingKeyValue(
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_rsa_pem(FfiConverterString.lower(`rsaPem`),_status)
})
        fun `fromSecret`(`secret`: kotlin.String): EncodingKeyValue =
            EncodingKeyValue(
    rustCall { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_encodingkeyvalue_from_secret(FfiConverterString.lower(`secret`),_status)
})
        
    }
    
}

internal object FfiConverterTypeEncodingKeyValue: FfiConverter<EncodingKeyValue, Pointer> {
    override fun lower(value: EncodingKeyValue): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): EncodingKeyValue {
        return EncodingKeyValue(value)
    }

    override fun read(buf: NoCopySource): EncodingKeyValue {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(buf.readLong().toPointer())
    }

    override fun allocationSize(value: EncodingKeyValue) = 8

    override fun write(value: EncodingKeyValue, buf: Buffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.writeLong(lower(value).toLong())
    }
}




public interface JwkValueInterface {
    
    fun `getJson`(): kotlin.String

    
    companion object
}

class JwkValue internal constructor(
    pointer: Pointer
) : FFIObject(pointer), JwkValueInterface {
    constructor(`jwkJson`: kotlin.String) :
        this(
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_jwkvalue_new(FfiConverterString.lower(`jwkJson`),_status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall { status: RustCallStatus ->
            UniFFILib.uniffi_sdjwtwrapper_fn_free_jwkvalue(this.pointer, status)
        }
    }

    override fun `getJson`(): kotlin.String =
        callWithPointer {
    rustCall { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_method_jwkvalue_get_json(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
    companion object
    
}

internal object FfiConverterTypeJwkValue: FfiConverter<JwkValue, Pointer> {
    override fun lower(value: JwkValue): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): JwkValue {
        return JwkValue(value)
    }

    override fun read(buf: NoCopySource): JwkValue {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(buf.readLong().toPointer())
    }

    override fun allocationSize(value: JwkValue) = 8

    override fun write(value: JwkValue, buf: Buffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.writeLong(lower(value).toLong())
    }
}




public interface SdjwtHolderWrapperInterface {
    @Throws(SdjwtException::class)
    fun `createPresentation`(`claimsToDiscloseJson`: kotlin.String, `nonce`: kotlin.String?, `aud`: kotlin.String?, `holderKey`: EncodingKeyValue?, `signAlg`: kotlin.String?): kotlin.String

    
    companion object
}

class SdjwtHolderWrapper internal constructor(
    pointer: Pointer
) : FFIObject(pointer), SdjwtHolderWrapperInterface {
    constructor(`sdJwtWithDisclosures`: kotlin.String, `serializationFormat`: SdjwtSerializationFormat) :
        this(
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_sdjwtholderwrapper_new(FfiConverterString.lower(`sdJwtWithDisclosures`),FfiConverterTypeSDJWTSerializationFormat.lower(`serializationFormat`),_status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall { status: RustCallStatus ->
            UniFFILib.uniffi_sdjwtwrapper_fn_free_sdjwtholderwrapper(this.pointer, status)
        }
    }

    
    @Throws(SdjwtException::class)override fun `createPresentation`(`claimsToDiscloseJson`: kotlin.String, `nonce`: kotlin.String?, `aud`: kotlin.String?, `holderKey`: EncodingKeyValue?, `signAlg`: kotlin.String?): kotlin.String =
        callWithPointer {
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_method_sdjwtholderwrapper_create_presentation(it, FfiConverterString.lower(`claimsToDiscloseJson`),FfiConverterOptionalString.lower(`nonce`),FfiConverterOptionalString.lower(`aud`),FfiConverterOptionalTypeEncodingKeyValue.lower(`holderKey`),FfiConverterOptionalString.lower(`signAlg`), _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
    companion object
    
}

internal object FfiConverterTypeSDJWTHolderWrapper: FfiConverter<SdjwtHolderWrapper, Pointer> {
    override fun lower(value: SdjwtHolderWrapper): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SdjwtHolderWrapper {
        return SdjwtHolderWrapper(value)
    }

    override fun read(buf: NoCopySource): SdjwtHolderWrapper {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(buf.readLong().toPointer())
    }

    override fun allocationSize(value: SdjwtHolderWrapper) = 8

    override fun write(value: SdjwtHolderWrapper, buf: Buffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.writeLong(lower(value).toLong())
    }
}




public interface SdjwtIssuerWrapperInterface {
    @Throws(SdjwtException::class)
    fun `issueSdJwtAllLevel`(`userClaims`: kotlin.String, `holderKey`: JwkValue?, `addDecoyClaims`: kotlin.Boolean, `serializationFormat`: SdjwtSerializationFormat): kotlin.String

    @Throws(SdjwtException::class)
    fun `issueSdJwtCustom`(`userClaims`: kotlin.String, `jsonPaths`: List<kotlin.String>, `holderKey`: JwkValue?, `addDecoyClaims`: kotlin.Boolean, `serializationFormat`: SdjwtSerializationFormat): kotlin.String

    @Throws(SdjwtException::class)
    fun `issueSdJwtNoSdClaims`(`userClaims`: kotlin.String, `holderKey`: JwkValue?, `addDecoyClaims`: kotlin.Boolean, `serializationFormat`: SdjwtSerializationFormat): kotlin.String

    @Throws(SdjwtException::class)
    fun `issueSdJwtTopLevel`(`userClaims`: kotlin.String, `holderKey`: JwkValue?, `addDecoyClaims`: kotlin.Boolean, `serializationFormat`: SdjwtSerializationFormat): kotlin.String

    
    companion object
}

class SdjwtIssuerWrapper internal constructor(
    pointer: Pointer
) : FFIObject(pointer), SdjwtIssuerWrapperInterface {
    constructor(`issuerKey`: EncodingKeyValue, `signAlg`: kotlin.String?) :
        this(
    rustCall { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_sdjwtissuerwrapper_new(FfiConverterTypeEncodingKeyValue.lower(`issuerKey`),FfiConverterOptionalString.lower(`signAlg`),_status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall { status: RustCallStatus ->
            UniFFILib.uniffi_sdjwtwrapper_fn_free_sdjwtissuerwrapper(this.pointer, status)
        }
    }

    
    @Throws(SdjwtException::class)override fun `issueSdJwtAllLevel`(`userClaims`: kotlin.String, `holderKey`: JwkValue?, `addDecoyClaims`: kotlin.Boolean, `serializationFormat`: SdjwtSerializationFormat): kotlin.String =
        callWithPointer {
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_all_level(it, FfiConverterString.lower(`userClaims`),FfiConverterOptionalTypeJwkValue.lower(`holderKey`),FfiConverterBoolean.lower(`addDecoyClaims`),FfiConverterTypeSDJWTSerializationFormat.lower(`serializationFormat`), _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(SdjwtException::class)override fun `issueSdJwtCustom`(`userClaims`: kotlin.String, `jsonPaths`: List<kotlin.String>, `holderKey`: JwkValue?, `addDecoyClaims`: kotlin.Boolean, `serializationFormat`: SdjwtSerializationFormat): kotlin.String =
        callWithPointer {
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_custom(it, FfiConverterString.lower(`userClaims`),FfiConverterSequenceString.lower(`jsonPaths`),FfiConverterOptionalTypeJwkValue.lower(`holderKey`),FfiConverterBoolean.lower(`addDecoyClaims`),FfiConverterTypeSDJWTSerializationFormat.lower(`serializationFormat`), _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(SdjwtException::class)override fun `issueSdJwtNoSdClaims`(`userClaims`: kotlin.String, `holderKey`: JwkValue?, `addDecoyClaims`: kotlin.Boolean, `serializationFormat`: SdjwtSerializationFormat): kotlin.String =
        callWithPointer {
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_no_sd_claims(it, FfiConverterString.lower(`userClaims`),FfiConverterOptionalTypeJwkValue.lower(`holderKey`),FfiConverterBoolean.lower(`addDecoyClaims`),FfiConverterTypeSDJWTSerializationFormat.lower(`serializationFormat`), _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(SdjwtException::class)override fun `issueSdJwtTopLevel`(`userClaims`: kotlin.String, `holderKey`: JwkValue?, `addDecoyClaims`: kotlin.Boolean, `serializationFormat`: SdjwtSerializationFormat): kotlin.String =
        callWithPointer {
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_method_sdjwtissuerwrapper_issue_sd_jwt_top_level(it, FfiConverterString.lower(`userClaims`),FfiConverterOptionalTypeJwkValue.lower(`holderKey`),FfiConverterBoolean.lower(`addDecoyClaims`),FfiConverterTypeSDJWTSerializationFormat.lower(`serializationFormat`), _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
    companion object
    
}

internal object FfiConverterTypeSDJWTIssuerWrapper: FfiConverter<SdjwtIssuerWrapper, Pointer> {
    override fun lower(value: SdjwtIssuerWrapper): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SdjwtIssuerWrapper {
        return SdjwtIssuerWrapper(value)
    }

    override fun read(buf: NoCopySource): SdjwtIssuerWrapper {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(buf.readLong().toPointer())
    }

    override fun allocationSize(value: SdjwtIssuerWrapper) = 8

    override fun write(value: SdjwtIssuerWrapper, buf: Buffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.writeLong(lower(value).toLong())
    }
}




public interface SdjwtVerifierWrapperInterface {
    
    fun `getVerifiedClaims`(): kotlin.String

    
    fun `verify`(`userClaimsJson`: kotlin.String): kotlin.Boolean

    
    companion object
}

class SdjwtVerifierWrapper internal constructor(
    pointer: Pointer
) : FFIObject(pointer), SdjwtVerifierWrapperInterface {
    constructor(`sdJwtPresentation`: kotlin.String, `publicKey`: kotlin.String, `expectedAud`: kotlin.String?, `expectedNonce`: kotlin.String?, `serializationFormat`: SdjwtSerializationFormat) :
        this(
    rustCallWithError(SdjwtException) { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_constructor_sdjwtverifierwrapper_new(FfiConverterString.lower(`sdJwtPresentation`),FfiConverterString.lower(`publicKey`),FfiConverterOptionalString.lower(`expectedAud`),FfiConverterOptionalString.lower(`expectedNonce`),FfiConverterTypeSDJWTSerializationFormat.lower(`serializationFormat`),_status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall { status: RustCallStatus ->
            UniFFILib.uniffi_sdjwtwrapper_fn_free_sdjwtverifierwrapper(this.pointer, status)
        }
    }

    override fun `getVerifiedClaims`(): kotlin.String =
        callWithPointer {
    rustCall { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_method_sdjwtverifierwrapper_get_verified_claims(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `verify`(`userClaimsJson`: kotlin.String): kotlin.Boolean =
        callWithPointer {
    rustCall { _status: RustCallStatus ->
    UniFFILib.uniffi_sdjwtwrapper_fn_method_sdjwtverifierwrapper_verify(it, FfiConverterString.lower(`userClaimsJson`), _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    

    
    companion object
    
}

internal object FfiConverterTypeSDJWTVerifierWrapper: FfiConverter<SdjwtVerifierWrapper, Pointer> {
    override fun lower(value: SdjwtVerifierWrapper): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SdjwtVerifierWrapper {
        return SdjwtVerifierWrapper(value)
    }

    override fun read(buf: NoCopySource): SdjwtVerifierWrapper {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(buf.readLong().toPointer())
    }

    override fun allocationSize(value: SdjwtVerifierWrapper) = 8

    override fun write(value: SdjwtVerifierWrapper, buf: Buffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.writeLong(lower(value).toLong())
    }
}





sealed class SdjwtException(message: kotlin.String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class ConversionException(message: kotlin.String) : SdjwtException(message)
        class DeserializationException(message: kotlin.String) : SdjwtException(message)
        class DataFieldMismatch(message: kotlin.String) : SdjwtException(message)
        class DuplicateDigestException(message: kotlin.String) : SdjwtException(message)
        class DuplicateKeyException(message: kotlin.String) : SdjwtException(message)
        class InvalidDisclosure(message: kotlin.String) : SdjwtException(message)
        class InvalidArrayDisclosureObject(message: kotlin.String) : SdjwtException(message)
        class InvalidPath(message: kotlin.String) : SdjwtException(message)
        class IndexOutOfBounds(message: kotlin.String) : SdjwtException(message)
        class InvalidState(message: kotlin.String) : SdjwtException(message)
        class InvalidInput(message: kotlin.String) : SdjwtException(message)
        class KeyNotFound(message: kotlin.String) : SdjwtException(message)
        class Unspecified(message: kotlin.String) : SdjwtException(message)
        

    internal companion object ErrorHandler : CallStatusErrorHandler<SdjwtException> {
        override fun lift(errorBuffer: RustBuffer): SdjwtException = FfiConverterTypeSDJWTError.lift(errorBuffer)
    }
}

internal object FfiConverterTypeSDJWTError : FfiConverterRustBuffer<SdjwtException> {
    override fun read(buf: NoCopySource): SdjwtException {
        
        return when(buf.readInt()) {
            1 -> SdjwtException.ConversionException(FfiConverterString.read(buf))
            2 -> SdjwtException.DeserializationException(FfiConverterString.read(buf))
            3 -> SdjwtException.DataFieldMismatch(FfiConverterString.read(buf))
            4 -> SdjwtException.DuplicateDigestException(FfiConverterString.read(buf))
            5 -> SdjwtException.DuplicateKeyException(FfiConverterString.read(buf))
            6 -> SdjwtException.InvalidDisclosure(FfiConverterString.read(buf))
            7 -> SdjwtException.InvalidArrayDisclosureObject(FfiConverterString.read(buf))
            8 -> SdjwtException.InvalidPath(FfiConverterString.read(buf))
            9 -> SdjwtException.IndexOutOfBounds(FfiConverterString.read(buf))
            10 -> SdjwtException.InvalidState(FfiConverterString.read(buf))
            11 -> SdjwtException.InvalidInput(FfiConverterString.read(buf))
            12 -> SdjwtException.KeyNotFound(FfiConverterString.read(buf))
            13 -> SdjwtException.Unspecified(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: SdjwtException): kotlin.Int {
        return 4
    }

    override fun write(value: SdjwtException, buf: Buffer) {
        when(value) {
            is SdjwtException.ConversionException -> {
                buf.writeInt(1)
                Unit
            }
            is SdjwtException.DeserializationException -> {
                buf.writeInt(2)
                Unit
            }
            is SdjwtException.DataFieldMismatch -> {
                buf.writeInt(3)
                Unit
            }
            is SdjwtException.DuplicateDigestException -> {
                buf.writeInt(4)
                Unit
            }
            is SdjwtException.DuplicateKeyException -> {
                buf.writeInt(5)
                Unit
            }
            is SdjwtException.InvalidDisclosure -> {
                buf.writeInt(6)
                Unit
            }
            is SdjwtException.InvalidArrayDisclosureObject -> {
                buf.writeInt(7)
                Unit
            }
            is SdjwtException.InvalidPath -> {
                buf.writeInt(8)
                Unit
            }
            is SdjwtException.IndexOutOfBounds -> {
                buf.writeInt(9)
                Unit
            }
            is SdjwtException.InvalidState -> {
                buf.writeInt(10)
                Unit
            }
            is SdjwtException.InvalidInput -> {
                buf.writeInt(11)
                Unit
            }
            is SdjwtException.KeyNotFound -> {
                buf.writeInt(12)
                Unit
            }
            is SdjwtException.Unspecified -> {
                buf.writeInt(13)
                Unit
            }
        }
    }

}




enum class SdjwtSerializationFormat {
    JSON,COMPACT;
    companion object
}

internal object FfiConverterTypeSDJWTSerializationFormat: FfiConverterRustBuffer<SdjwtSerializationFormat> {
    override fun read(buf: NoCopySource) = try {
        SdjwtSerializationFormat.values()[buf.readInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: SdjwtSerializationFormat) = 4

    override fun write(value: SdjwtSerializationFormat, buf: Buffer) {
        buf.writeInt(value.ordinal + 1)
    }
}






internal object FfiConverterOptionalString: FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: NoCopySource): kotlin.String? {
        if (buf.readByte().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): kotlin.Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: kotlin.String?, buf: Buffer) {
        if (value == null) {
            buf.writeByte(0)
        } else {
            buf.writeByte(1)
            FfiConverterString.write(value, buf)
        }
    }
}




internal object FfiConverterOptionalTypeEncodingKeyValue: FfiConverterRustBuffer<EncodingKeyValue?> {
    override fun read(buf: NoCopySource): EncodingKeyValue? {
        if (buf.readByte().toInt() == 0) {
            return null
        }
        return FfiConverterTypeEncodingKeyValue.read(buf)
    }

    override fun allocationSize(value: EncodingKeyValue?): kotlin.Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeEncodingKeyValue.allocationSize(value)
        }
    }

    override fun write(value: EncodingKeyValue?, buf: Buffer) {
        if (value == null) {
            buf.writeByte(0)
        } else {
            buf.writeByte(1)
            FfiConverterTypeEncodingKeyValue.write(value, buf)
        }
    }
}




internal object FfiConverterOptionalTypeJwkValue: FfiConverterRustBuffer<JwkValue?> {
    override fun read(buf: NoCopySource): JwkValue? {
        if (buf.readByte().toInt() == 0) {
            return null
        }
        return FfiConverterTypeJwkValue.read(buf)
    }

    override fun allocationSize(value: JwkValue?): kotlin.Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeJwkValue.allocationSize(value)
        }
    }

    override fun write(value: JwkValue?, buf: Buffer) {
        if (value == null) {
            buf.writeByte(0)
        } else {
            buf.writeByte(1)
            FfiConverterTypeJwkValue.write(value, buf)
        }
    }
}




internal object FfiConverterSequenceString: FfiConverterRustBuffer<List<kotlin.String>> {
    override fun read(buf: NoCopySource): List<kotlin.String> {
        val len = buf.readInt()
        return List<kotlin.String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.String>): kotlin.Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<kotlin.String>, buf: Buffer) {
        buf.writeInt(value.size)
        value.forEach {
            FfiConverterString.write(it, buf)
        }
    }
}

