/*
 * Decompiled with CFR 0.152.
 */
package io.iohk.atala.prism.credentials.json;

import io.iohk.atala.prism.credentials.CredentialParsingError;
import io.iohk.atala.prism.credentials.PrismCredential;
import io.iohk.atala.prism.credentials.content.CredentialContent;
import io.iohk.atala.prism.crypto.EC;
import io.iohk.atala.prism.crypto.keys.ECPrivateKey;
import io.iohk.atala.prism.crypto.signature.ECSignature;
import io.iohk.atala.prism.protos.util.Base64Utils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\t\u0010\u001f\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lio/iohk/atala/prism/credentials/json/JsonBasedCredential;", "Lio/iohk/atala/prism/credentials/PrismCredential;", "content", "Lio/iohk/atala/prism/credentials/content/CredentialContent;", "signature", "Lio/iohk/atala/prism/crypto/signature/ECSignature;", "(Lio/iohk/atala/prism/credentials/content/CredentialContent;Lio/iohk/atala/prism/crypto/signature/ECSignature;)V", "canonicalForm", "", "getCanonicalForm", "()Ljava/lang/String;", "getContent", "()Lio/iohk/atala/prism/credentials/content/CredentialContent;", "contentBytes", "", "getContentBytes", "()[B", "getSignature", "()Lio/iohk/atala/prism/crypto/signature/ECSignature;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "sign", "privateKey", "Lio/iohk/atala/prism/crypto/keys/ECPrivateKey;", "toString", "Companion", "prism-credentials"})
public final class JsonBasedCredential
extends PrismCredential {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CredentialContent content;
    @Nullable
    private final ECSignature signature;
    @NotNull
    private final byte[] contentBytes;
    @NotNull
    private final String canonicalForm;
    private static final char SEPARATOR = (char)46;

    public JsonBasedCredential(@NotNull CredentialContent content, @Nullable ECSignature signature) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.content = content;
        this.signature = signature;
        this.contentBytes = StringsKt.encodeToByteArray((String)this.getContent().getFields().toString());
        this.canonicalForm = this.getSignature() != null ? Base64Utils.INSTANCE.encode(this.getContentBytes()) + SEPARATOR + Base64Utils.INSTANCE.encode(this.getSignature().getEncoded()) : StringsKt.decodeToString((byte[])this.getContentBytes());
    }

    public /* synthetic */ JsonBasedCredential(CredentialContent credentialContent, ECSignature eCSignature, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            eCSignature = null;
        }
        this(credentialContent, eCSignature);
    }

    @Override
    @NotNull
    public CredentialContent getContent() {
        return this.content;
    }

    @Override
    @Nullable
    public ECSignature getSignature() {
        return this.signature;
    }

    @Override
    @NotNull
    public byte[] getContentBytes() {
        return this.contentBytes;
    }

    @Override
    @NotNull
    public String getCanonicalForm() {
        return this.canonicalForm;
    }

    @Override
    @NotNull
    public PrismCredential sign(@NotNull ECPrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return JsonBasedCredential.copy$default(this, null, EC.INSTANCE.signBytes(this.getContentBytes(), privateKey), 1, null);
    }

    @NotNull
    public final CredentialContent component1() {
        return this.getContent();
    }

    @Nullable
    public final ECSignature component2() {
        return this.getSignature();
    }

    @NotNull
    public final JsonBasedCredential copy(@NotNull CredentialContent content, @Nullable ECSignature signature) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return new JsonBasedCredential(content, signature);
    }

    public static /* synthetic */ JsonBasedCredential copy$default(JsonBasedCredential jsonBasedCredential, CredentialContent credentialContent, ECSignature eCSignature, int n, Object object) {
        if ((n & 1) != 0) {
            credentialContent = jsonBasedCredential.getContent();
        }
        if ((n & 2) != 0) {
            eCSignature = jsonBasedCredential.getSignature();
        }
        return jsonBasedCredential.copy(credentialContent, eCSignature);
    }

    @NotNull
    public String toString() {
        return "JsonBasedCredential(content=" + this.getContent() + ", signature=" + this.getSignature() + ")";
    }

    public int hashCode() {
        int result = this.getContent().hashCode();
        result = result * 31 + (this.getSignature() == null ? 0 : this.getSignature().hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonBasedCredential)) {
            return false;
        }
        JsonBasedCredential jsonBasedCredential = (JsonBasedCredential)other;
        if (!Intrinsics.areEqual((Object)this.getContent(), (Object)jsonBasedCredential.getContent())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getSignature(), (Object)jsonBasedCredential.getSignature());
    }

    @JvmStatic
    private static final JsonBasedCredential parseUnsignedCredential(String credential) {
        return JsonBasedCredential.Companion.parseUnsignedCredential(credential);
    }

    @JvmStatic
    private static final JsonBasedCredential parseSignedCredential(String credential) {
        return JsonBasedCredential.Companion.parseSignedCredential(credential);
    }

    @JvmStatic
    @NotNull
    public static final JsonBasedCredential fromString(@NotNull String credential) {
        return Companion.fromString(credential);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/iohk/atala/prism/credentials/json/JsonBasedCredential$Companion;", "", "()V", "SEPARATOR", "", "fromString", "Lio/iohk/atala/prism/credentials/json/JsonBasedCredential;", "credential", "", "parseSignedCredential", "parseUnsignedCredential", "prism-credentials"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final JsonBasedCredential parseUnsignedCredential(String credential) {
            CredentialContent credentialContent = CredentialContent.Companion.fromString(StringsKt.decodeToString((byte[])Base64Utils.INSTANCE.decode(credential)));
            return new JsonBasedCredential(credentialContent, null, 2, null);
        }

        @JvmStatic
        private final JsonBasedCredential parseSignedCredential(String credential) {
            char[] cArray = new char[]{SEPARATOR};
            List contentWithSignature = StringsKt.split$default((CharSequence)credential, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (contentWithSignature.size() == 2) {
                String content = (String)contentWithSignature.get(0);
                String signature = (String)contentWithSignature.get(1);
                try {
                    CredentialContent credentialContent = CredentialContent.Companion.fromString(StringsKt.decodeToString((byte[])Base64Utils.INSTANCE.decode(content)));
                    return new JsonBasedCredential(credentialContent, new ECSignature(Base64Utils.INSTANCE.decode(signature)));
                }
                catch (Exception e) {
                    throw new CredentialParsingError("Failed to parse signed credential content: " + e.getMessage());
                }
            }
            throw new CredentialParsingError("Failed to parse signed credential. Expected format: [encoded credential]" + SEPARATOR + "[encoded signature]");
        }

        @JvmStatic
        @NotNull
        public final JsonBasedCredential fromString(@NotNull String credential) {
            Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
            try {
                return this.parseUnsignedCredential(credential);
            }
            catch (Exception e) {
                return this.parseSignedCredential(credential);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

