/*
 * Decompiled with CFR 0.152.
 */
package io.iohk.atala.prism.credentials;

import io.iohk.atala.prism.credentials.content.CredentialContent;
import io.iohk.atala.prism.crypto.EC;
import io.iohk.atala.prism.crypto.Sha256;
import io.iohk.atala.prism.crypto.Sha256Digest;
import io.iohk.atala.prism.crypto.keys.ECPrivateKey;
import io.iohk.atala.prism.crypto.keys.ECPublicKey;
import io.iohk.atala.prism.crypto.signature.ECSignature;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lio/iohk/atala/prism/credentials/PrismCredential;", "", "()V", "canonicalForm", "", "getCanonicalForm", "()Ljava/lang/String;", "content", "Lio/iohk/atala/prism/credentials/content/CredentialContent;", "getContent", "()Lio/iohk/atala/prism/credentials/content/CredentialContent;", "contentBytes", "", "getContentBytes", "()[B", "signature", "Lio/iohk/atala/prism/crypto/signature/ECSignature;", "getSignature", "()Lio/iohk/atala/prism/crypto/signature/ECSignature;", "hash", "Lio/iohk/atala/prism/crypto/Sha256Digest;", "isValidSignature", "", "publicKey", "Lio/iohk/atala/prism/crypto/keys/ECPublicKey;", "isVerifiable", "sign", "privateKey", "Lio/iohk/atala/prism/crypto/keys/ECPrivateKey;", "prism-credentials"})
public abstract class PrismCredential {
    @NotNull
    public abstract byte[] getContentBytes();

    @NotNull
    public abstract CredentialContent getContent();

    @Nullable
    public abstract ECSignature getSignature();

    @NotNull
    public abstract String getCanonicalForm();

    public final boolean isVerifiable() {
        return this.getSignature() != null;
    }

    @NotNull
    public final Sha256Digest hash() {
        return Sha256.compute((byte[])StringsKt.encodeToByteArray((String)this.getCanonicalForm()));
    }

    @NotNull
    public abstract PrismCredential sign(@NotNull ECPrivateKey var1);

    public final boolean isValidSignature(@NotNull ECPublicKey publicKey) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        ECSignature eCSignature = this.getSignature();
        if (eCSignature == null) {
            bl = false;
        } else {
            boolean bl2;
            ECSignature it = eCSignature;
            boolean bl3 = false;
            bl = bl2 = EC.INSTANCE.verifyBytes(this.getContentBytes(), publicKey, it);
        }
        return bl;
    }
}

