/*
 * Decompiled with CFR 0.152.
 */
package io.iohk.atala.prism.credentials;

import io.iohk.atala.prism.crypto.MerkleRoot;
import io.iohk.atala.prism.crypto.Sha256;
import io.iohk.atala.prism.crypto.Sha256Digest;
import io.iohk.atala.prism.protos.CredentialBatchData;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pbandk.ByteArr;
import pbandk.Message;
import pbandk.MessageKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/iohk/atala/prism/credentials/CredentialBatchId;", "", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "prism-credentials"})
public final class CredentialBatchId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private static final Regex CREDENTIAL_BATCH_ID_RE = new Regex("^[0-9a-f]{64}$");

    private CredentialBatchId(String id) {
        this.id = id;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final CredentialBatchId copy(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new CredentialBatchId(id);
    }

    public static /* synthetic */ CredentialBatchId copy$default(CredentialBatchId credentialBatchId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = credentialBatchId.id;
        }
        return credentialBatchId.copy(string);
    }

    @NotNull
    public String toString() {
        return "CredentialBatchId(id=" + this.id + ")";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CredentialBatchId)) {
            return false;
        }
        CredentialBatchId credentialBatchId = (CredentialBatchId)other;
        return Intrinsics.areEqual((Object)this.id, (Object)credentialBatchId.id);
    }

    @JvmStatic
    @Nullable
    public static final CredentialBatchId fromString(@NotNull String id) {
        return Companion.fromString(id);
    }

    @JvmStatic
    @NotNull
    public static final CredentialBatchId fromDigest(@NotNull Sha256Digest digest) {
        return Companion.fromDigest(digest);
    }

    @JvmStatic
    @NotNull
    public static final CredentialBatchId fromBatchData(@NotNull String issuerDidSuffix, @NotNull MerkleRoot merkleRoot) {
        return Companion.fromBatchData(issuerDidSuffix, merkleRoot);
    }

    @JvmStatic
    @NotNull
    public static final CredentialBatchId random() {
        return Companion.random();
    }

    public /* synthetic */ CredentialBatchId(String id, DefaultConstructorMarker $constructor_marker) {
        this(id);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0007J\b\u0010\u0010\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/iohk/atala/prism/credentials/CredentialBatchId$Companion;", "", "()V", "CREDENTIAL_BATCH_ID_RE", "Lkotlin/text/Regex;", "fromBatchData", "Lio/iohk/atala/prism/credentials/CredentialBatchId;", "issuerDidSuffix", "", "merkleRoot", "Lio/iohk/atala/prism/crypto/MerkleRoot;", "fromDigest", "digest", "Lio/iohk/atala/prism/crypto/Sha256Digest;", "fromString", "id", "random", "prism-credentials"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final CredentialBatchId fromString(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            CharSequence charSequence = id;
            return CREDENTIAL_BATCH_ID_RE.matches(charSequence) ? new CredentialBatchId(id, null) : null;
        }

        @JvmStatic
        @NotNull
        public final CredentialBatchId fromDigest(@NotNull Sha256Digest digest) {
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            return new CredentialBatchId(digest.getHexValue(), null);
        }

        @JvmStatic
        @NotNull
        public final CredentialBatchId fromBatchData(@NotNull String issuerDidSuffix, @NotNull MerkleRoot merkleRoot) {
            Intrinsics.checkNotNullParameter((Object)issuerDidSuffix, (String)"issuerDidSuffix");
            Intrinsics.checkNotNullParameter((Object)merkleRoot, (String)"merkleRoot");
            Sha256Digest digest = Sha256.compute((byte[])MessageKt.encodeToByteArray((Message)((Message)new CredentialBatchData(issuerDidSuffix, new ByteArr(merkleRoot.getHash().getValue()), null, 4, null))));
            return this.fromDigest(digest);
        }

        @JvmStatic
        @NotNull
        public final CredentialBatchId random() {
            boolean $i$f$uuid4 = false;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
            String string = uUID.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uuid4().toString()");
            return new CredentialBatchId(Sha256.compute((byte[])StringsKt.encodeToByteArray((String)string)).getHexValue(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

