package io.iohk.atala.prism.api.node

import io.iohk.atala.prism.api.VerificationResult
import io.iohk.atala.prism.api.models.AtalaOperationId
import io.iohk.atala.prism.api.models.AtalaOperationInfo
import io.iohk.atala.prism.credentials.PrismCredential
import io.iohk.atala.prism.crypto.MerkleInclusionProof
import io.iohk.atala.prism.crypto.Sha256Digest
import io.iohk.atala.prism.identity.PrismDid
import io.iohk.atala.prism.protos.GrpcOptions
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.future.future
import java.util.concurrent.CompletableFuture

public open class NodePublicApiAsyncImpl(options: GrpcOptions) : NodePublicApiAsync {
    private val nodePublicApi = NodePublicApiImpl(options)

    override fun healthCheck(): CompletableFuture<Unit> =
        GlobalScope.future { nodePublicApi.healthCheck() }

    override fun verify(
        signedCredential: PrismCredential,
        merkleInclusionProof: MerkleInclusionProof
    ): CompletableFuture<VerificationResult> =
        GlobalScope.future { nodePublicApi.verify(signedCredential, merkleInclusionProof) }

    override fun getDidDocument(did: PrismDid): CompletableFuture<PrismDidState> =
        GlobalScope.future { nodePublicApi.getDidDocument(did) }

    override fun getOperationInfo(operationId: AtalaOperationId): CompletableFuture<AtalaOperationInfo> =
        GlobalScope.future { nodePublicApi.getOperationInfo(operationId) }

    override fun getCredentialRevocationTime(
        batchId: String,
        credentialHash: Sha256Digest
    ): CompletableFuture<GetCredentialRevocationTimeResult> =
        GlobalScope.future { nodePublicApi.getCredentialRevocationTime(batchId, credentialHash) }

    override fun getBatchState(batchId: String): CompletableFuture<BatchState> =
        GlobalScope.future { nodePublicApi.getBatchState(batchId) }

    override fun getNodeBuildInfo(): CompletableFuture<NodeBuildInfo> =
        GlobalScope.future { nodePublicApi.getNodeBuildInfo() }

    override fun getNodeNetworkProtocolInfo(): CompletableFuture<NodeNetworkProtocolInfo> =
        GlobalScope.future { nodePublicApi.getNodeNetworkProtocolInfo() }
}
