package io.iohk.atala.prism.api.node

import io.iohk.atala.prism.api.VerificationResult
import io.iohk.atala.prism.api.models.AtalaOperationId
import io.iohk.atala.prism.api.models.AtalaOperationInfo
import io.iohk.atala.prism.credentials.PrismCredential
import io.iohk.atala.prism.crypto.MerkleInclusionProof
import io.iohk.atala.prism.crypto.Sha256Digest
import io.iohk.atala.prism.identity.PrismDid
import java.util.concurrent.CompletableFuture

public interface NodePublicApiAsync {
    public fun healthCheck(): CompletableFuture<Unit>

    public fun verify(
        signedCredential: PrismCredential,
        merkleInclusionProof: MerkleInclusionProof
    ): CompletableFuture<VerificationResult>

    public fun getDidDocument(did: PrismDid): CompletableFuture<PrismDidState>

    public fun getOperationInfo(operationId: AtalaOperationId): CompletableFuture<AtalaOperationInfo>

    public fun getCredentialRevocationTime(
        batchId: String,
        credentialHash: Sha256Digest
    ): CompletableFuture<GetCredentialRevocationTimeResult>

    public fun getBatchState(
        batchId: String,
    ): CompletableFuture<BatchState>

    public fun getNodeBuildInfo(): CompletableFuture<NodeBuildInfo>

    public fun getNodeNetworkProtocolInfo(): CompletableFuture<NodeNetworkProtocolInfo>
}
