package io.iohk.atala.prism.api.node

import com.ionspin.kotlin.bignum.integer.BigInteger
import io.iohk.atala.prism.api.common.AuthDetails
import io.iohk.atala.prism.common.PrismSdkInternal
import io.iohk.atala.prism.protos.GrpcOptions
import io.iohk.atala.prism.protos.SignedAtalaOperation
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.future.future
import java.util.concurrent.CompletableFuture

public class NodeExplorerApiAsyncImpl(options: GrpcOptions) : NodeExplorerApiAsync {
    private val nodeExplorerApi = NodeExplorerAuthApiImpl(options)

    @OptIn(PrismSdkInternal::class)
    override fun getScheduledOperations(
        operationsKind: AtalaOperationType?,
        authDetails: AuthDetails
    ): CompletableFuture<List<SignedAtalaOperation>> =
        GlobalScope.future { nodeExplorerApi.getScheduledOperations(operationsKind, authDetails) }

    override fun getWalletTransactions(
        transactionStatus: WalletTransactionStatus?,
        lastSeenTransactionId: String?,
        limit: Int,
        authDetails: AuthDetails
    ): CompletableFuture<List<TransactionState>> =
        GlobalScope.future {
            nodeExplorerApi.getWalletTransactions(
                transactionStatus,
                lastSeenTransactionId,
                limit,
                authDetails
            )
        }

    override fun getWalletBalance(authDetails: AuthDetails): CompletableFuture<BigInteger> =
        GlobalScope.future { nodeExplorerApi.getWalletBalance(authDetails) }
}
